/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.LifecycleImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LifecycleFactoryImpl
extends LifecycleFactory {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    protected ConcurrentHashMap<String, Lifecycle> lifecycleMap = new ConcurrentHashMap();

    public LifecycleFactoryImpl() {
        super(null);
        this.lifecycleMap.put("DEFAULT", new LifecycleImpl(FacesContext.getCurrentInstance()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created Default Lifecycle");
        }
    }

    @Override
    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        if (lifecycleId == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycleId"));
        }
        if (lifecycle == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycle"));
        }
        if (null != this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params);
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", params));
            }
            throw new IllegalArgumentException(message);
        }
        this.lifecycleMap.put(lifecycleId, lifecycle);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addedLifecycle: " + lifecycleId + " " + lifecycle);
        }
    }

    @Override
    public Lifecycle getLifecycle(String lifecycleId) throws FacesException {
        if (null == lifecycleId) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycleId"));
        }
        if (null == this.lifecycleMap.get(lifecycleId)) {
            Object[] params = new Object[]{lifecycleId};
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_CREATE_LIFECYCLE_ERROR", params);
            throw new IllegalArgumentException(message);
        }
        Lifecycle result = this.lifecycleMap.get(lifecycleId);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getLifecycle: " + lifecycleId + " " + result);
        }
        return result;
    }

    @Override
    public Iterator<String> getLifecycleIds() {
        return ((ConcurrentHashMap.KeySetView)this.lifecycleMap.keySet()).iterator();
    }
}

