/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributes;
import jakarta.faces.view.facelets.TagDecorator;
import java.util.HashMap;
import java.util.Map;

class DefaultTagDecorator
implements TagDecorator {
    private ElementConverter defaultElementConverter = new ElementConverter("jsf:element");

    DefaultTagDecorator() {
    }

    @Override
    public Tag decorate(Tag tag) {
        String ns = tag.getNamespace();
        if (!this.hasJsfAttribute(tag)) {
            return null;
        }
        if (!"".equals(ns) && !"http://www.w3.org/1999/xhtml".equals(ns)) {
            throw new FaceletException("Elements with namespace " + ns + " may not have attributes in namespace " + Namespace.jsf.uri + ". Namespace " + Namespace.jsf.uri + " is intended for otherwise non-JSF-aware markup, such as <input type=\"text\" jsf:id > It is not valid to have <h:commandButton jsf:id=\"button\" />.");
        }
        for (Mapper mapper : Mapper.values()) {
            if (!tag.getLocalName().equals(mapper.name())) continue;
            return mapper.elementConverter.decorate(tag);
        }
        return this.defaultElementConverter.decorate(tag);
    }

    private boolean hasJsfAttribute(Tag tag) {
        for (String ns : tag.getAttributes().getNamespaces()) {
            if (!Namespace.jsf.uri.equals(ns)) continue;
            return true;
        }
        return false;
    }

    private static class ElementConverter
    implements TagDecorator {
        private String localName;
        private Namespace namespace;
        private String arbiterAttributeName;
        private String arbiterAttributeNamespace = "";
        private Map<String, String> additionalMappings = new HashMap<String, String>();
        private String otherHtmlIdAttribute;

        private ElementConverter() {
        }

        private ElementConverter(String faceletsTag) {
            this(faceletsTag, (String)null);
        }

        private ElementConverter(String faceletsTag, String arbiterAttributeName) {
            String[] strings = faceletsTag.split(":");
            this.namespace = Namespace.valueOf(strings[0]);
            this.localName = strings[1];
            this.arbiterAttributeName = arbiterAttributeName;
            if (arbiterAttributeName != null && arbiterAttributeName.indexOf(58) > 0) {
                strings = arbiterAttributeName.split(":");
                this.arbiterAttributeNamespace = Namespace.valueOf(strings[0]).uri;
                this.arbiterAttributeName = strings[1];
            }
        }

        private ElementConverter map(String arbiterAttributeValue, String faceletsTagLocalName) {
            this.additionalMappings.put(arbiterAttributeValue, faceletsTagLocalName);
            return this;
        }

        private ElementConverter id(String otherHtmlIdAttribute) {
            this.otherHtmlIdAttribute = otherHtmlIdAttribute;
            return this;
        }

        @Override
        public Tag decorate(Tag tag) {
            if (this.arbiterAttributeName == null) {
                return this.convertTag(tag, this.namespace, this.localName);
            }
            TagAttribute arbiterAttribute = tag.getAttributes().get(this.arbiterAttributeNamespace, this.arbiterAttributeName);
            if (arbiterAttribute == null) {
                return null;
            }
            String myLocalName = this.additionalMappings.get(arbiterAttribute.getValue());
            if (myLocalName == null) {
                myLocalName = this.localName;
            }
            return this.convertTag(tag, this.namespace, myLocalName);
        }

        protected Tag convertTag(Tag tag, Namespace namespace, String localName) {
            Location location = tag.getLocation();
            String ns = namespace.uri;
            String qName = namespace.name() + ":" + localName;
            TagAttributes attributes = this.convertAttributes(tag.getAttributes());
            Tag converted = new Tag(location, ns, localName, qName, attributes);
            for (TagAttribute tagAttribute : attributes.getAll()) {
                tagAttribute.setTag(converted);
            }
            return converted;
        }

        protected TagAttributes convertAttributes(TagAttributes original) {
            HashMap<String, TagAttribute> attributes = new HashMap<String, TagAttribute>();
            TagAttribute elementName = this.createElementName(original.getTag());
            attributes.put(elementName.getQName(), elementName);
            for (TagAttribute attribute : original.getAll()) {
                TagAttribute converted = this.convertTagAttribute(attribute);
                attributes.put(converted.getQName(), converted);
            }
            return new TagAttributesImpl(attributes.values().toArray(new TagAttribute[attributes.size()]));
        }

        private TagAttribute createElementName(Tag tag) {
            Location location = tag.getLocation();
            String ns = Namespace.p.uri;
            String myLocalName = "elementName";
            String qName = "p:" + myLocalName;
            String value = tag.getLocalName();
            return new TagAttributeImpl(location, ns, myLocalName, qName, value);
        }

        protected TagAttribute convertTagAttribute(TagAttribute attribute) {
            String qName;
            Location location = attribute.getLocation();
            String ns = attribute.getNamespace();
            String myLocalName = attribute.getLocalName();
            String value = attribute.getValue();
            if (Namespace.jsf.uri.equals(attribute.getNamespace())) {
                qName = myLocalName;
                ns = "";
            } else {
                if (ns.length() != 0 && !ns.equals(attribute.getTag().getNamespace())) {
                    return attribute;
                }
                if (attribute.getLocalName().equals(this.otherHtmlIdAttribute)) {
                    qName = "id";
                    myLocalName = "id";
                } else {
                    qName = "p:" + myLocalName;
                    ns = Namespace.p.uri;
                }
            }
            return new TagAttributeImpl(location, ns, myLocalName, qName, value);
        }

        static /* synthetic */ ElementConverter access$200(ElementConverter x0, String x1) {
            return x0.id(x1);
        }

        static /* synthetic */ ElementConverter access$300(ElementConverter x0, String x1, String x2) {
            return x0.map(x1, x2);
        }
    }

    private static enum Namespace {
        p("http://xmlns.jcp.org/jsf/passthrough"),
        jsf("http://xmlns.jcp.org/jsf"),
        h("http://java.sun.com/jsf/html");

        private String uri;

        private Namespace(String uri) {
            this.uri = uri;
        }
    }

    private static enum Mapper {
        a(new ElementConverter("h:commandLink", "jsf:action"), new ElementConverter("h:commandLink", "jsf:actionListener"), new ElementConverter("h:outputLink", "jsf:value"), new ElementConverter("h:link", "jsf:outcome")),
        img("h:graphicImage"),
        body("h:body"),
        head("h:head"),
        label("h:outputLabel"),
        script("h:outputScript"),
        link("h:outputStylesheet"),
        form("h:form"),
        textarea("h:inputTextarea"),
        button(new ElementConverter("h:button", "jsf:outcome"), new ElementConverter("h:commandButton")),
        select(ElementConverter.access$200(new ElementConverter("h:selectManyListbox", "multiple"), "name"), ElementConverter.access$200(new ElementConverter("h:selectOneListbox"), "name")),
        input(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$200(new ElementConverter("h:inputText", "type"), "name"), "hidden", "inputHidden"), "password", "inputSecret"), "number", "inputText"), "search", "inputText"), "email", "inputText"), "datetime", "inputText"), "date", "inputText"), "month", "inputText"), "week", "inputText"), "time", "inputText"), "datetime-local", "inputText"), "range", "inputText"), "color", "inputText"), "url", "inputText"), "checkbox", "selectBooleanCheckbox"), "file", "inputFile"), "submit", "commandButton"), "reset", "commandButton"), "button", "button"));

        private ElementConverter elementConverter;

        private Mapper(final ElementConverter ... elementConverters) {
            this.elementConverter = elementConverters.length == 1 ? elementConverters[0] : new ElementConverter(){

                @Override
                public Tag decorate(Tag tag) {
                    for (ElementConverter converter : elementConverters) {
                        Tag decorated = converter.decorate(tag);
                        if (decorated == null) continue;
                        return decorated;
                    }
                    return null;
                }
            };
        }

        private Mapper(String faceletTag) {
            this.elementConverter = new ElementConverter(faceletTag);
        }
    }
}

