/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context.flash;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.flash.SessionHelper;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.util.ByteArrayGuardAESCTR;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.Flash;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostKeepFlashValueEvent;
import jakarta.faces.event.PostPutFlashValueEvent;
import jakarta.faces.event.PreClearFlashEvent;
import jakarta.faces.event.PreRemoveFlashValueEvent;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELFlash
extends Flash {
    private Map<String, Map<String, Object>> flashInnerMap;
    private final AtomicLong sequenceNumber;
    private int numberOfConcurentFlashUsers;
    private long numberOfFlashesBetweenFlashReapings;
    private final boolean distributable;
    private ByteArrayGuardAESCTR guard;
    private static final String ELEMENT_TYPE_MISMATCH = "element-type-mismatch";
    private static final Logger LOGGER = FacesLogger.FLASH.getLogger();
    static final String PREFIX = "csfcf";
    static final String FLASH_ATTRIBUTE_NAME = "csfcff";
    static final String FLASH_COOKIE_NAME = "csfcfc";
    static final String FLASH_NOW_REQUEST_KEY = "csfcffn";
    public static final String ACT_AS_DO_LAST_PHASE_ACTIONS = ELFlash.class.getPackage().getName() + ".ACT_AS_DO_LAST_PHASE_ACTIONS";

    private ELFlash(ExternalContext extContext) {
        WebConfiguration config;
        block5: {
            String value;
            block4: {
                this.flashInnerMap = null;
                this.sequenceNumber = new AtomicLong(0L);
                this.numberOfConcurentFlashUsers = Integer.parseInt(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers.getDefaultValue());
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings.getDefaultValue());
                this.flashInnerMap = new ConcurrentHashMap<String, Map<String, Object>>();
                config = WebConfiguration.getInstance(extContext);
                try {
                    value = config.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers);
                    this.numberOfConcurentFlashUsers = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, "Unable to set number of concurrent flash users.  Defaulting to {0}", this.numberOfConcurentFlashUsers);
                }
            }
            try {
                value = config.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings);
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                LOGGER.log(Level.WARNING, "Unable to set number flashes between flash repaings.  Defaulting to {0}", this.numberOfFlashesBetweenFlashReapings);
            }
        }
        this.distributable = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable);
        this.guard = new ByteArrayGuardAESCTR();
    }

    public static Map<String, Object> getFlash() {
        FacesContext context = FacesContext.getCurrentInstance();
        return ELFlash.getFlash(context.getExternalContext(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ELFlash getFlash(ExternalContext extContext, boolean create) {
        Object object;
        Map<String, Object> appMap = extContext.getApplicationMap();
        ELFlash flash = (ELFlash)appMap.get(FLASH_ATTRIBUTE_NAME);
        if (null == flash && create) {
            object = extContext.getContext();
            synchronized (object) {
                flash = (ELFlash)appMap.get(FLASH_ATTRIBUTE_NAME);
                if (null == flash) {
                    flash = new ELFlash(extContext);
                    appMap.put(FLASH_ATTRIBUTE_NAME, flash);
                }
            }
        }
        if (appMap.get(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable.getQualifiedName()) != null) {
            object = extContext.getContext();
            synchronized (object) {
                if (extContext.getSession(false) != null) {
                    SessionHelper sessionHelper = SessionHelper.getInstance(extContext);
                    if (sessionHelper == null) {
                        sessionHelper = new SessionHelper();
                    }
                    sessionHelper.update(extContext, flash);
                }
            }
        }
        return flash;
    }

    @Override
    public boolean isKeepMessages() {
        boolean result = false;
        Map<String, Object> phaseMap = this.loggingGetPhaseMapForReading(false);
        if (null != phaseMap) {
            Object value = phaseMap.get(CONSTANTS.KeepAllMessagesAttributeName.toString());
            result = null != value ? (Boolean)value : false;
        }
        return result;
    }

    @Override
    public void setKeepMessages(boolean newValue) {
        this.loggingGetPhaseMapForWriting(false).put(CONSTANTS.KeepAllMessagesAttributeName.toString(), newValue);
    }

    @Override
    public boolean isRedirect() {
        boolean result = false;
        FacesContext context = FacesContext.getCurrentInstance();
        Map<Object, Object> contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, false);
        if (null != flashManager) {
            result = flashManager.getPreviousRequestFlashInfo().isIsRedirect();
        }
        return result;
    }

    @Override
    public void setRedirect(boolean newValue) {
    }

    @Override
    public Object get(Object key) {
        SessionHelper sessionHelper;
        Object result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != key) {
            if (key.equals("keepMessages")) {
                result = this.isKeepMessages();
            } else if (key.equals("redirect")) {
                result = this.isRedirect();
            } else if (this.isKeepFlagSet(context)) {
                result = this.getPhaseMapForReading().get(key);
                this.keep(key.toString());
                this.clearKeepFlag(context);
                return result;
            }
        }
        if (null == result) {
            result = this.getPhaseMapForReading().get(key);
        }
        if (this.distributable && context.getExternalContext().getSession(false) != null && (sessionHelper = SessionHelper.getInstance(context.getExternalContext())) != null) {
            sessionHelper.update(context.getExternalContext(), this);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "get({0}) = {1}", new Object[]{key, result});
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        SessionHelper sessionHelper;
        Boolean b = null;
        Boolean result = null;
        boolean wasSpecialPut = false;
        if (null != key) {
            if (key.equals("keepMessages")) {
                b = Boolean.parseBoolean((String)value);
                this.setKeepMessages(b);
                wasSpecialPut = true;
            }
            if (key.equals("redirect")) {
                b = Boolean.parseBoolean((String)value);
                this.setRedirect(b);
                wasSpecialPut = true;
            }
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (!wasSpecialPut) {
            Boolean bl = result = null == b ? this.getPhaseMapForWriting().put(key, value) : b;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "put({0},{1})", new Object[]{key, value});
            }
            context.getApplication().publishEvent(context, PostPutFlashValueEvent.class, key);
        }
        if (this.distributable && context.getExternalContext().getSession(false) != null && (sessionHelper = SessionHelper.getInstance(context.getExternalContext())) != null) {
            sessionHelper.update(context.getExternalContext(), this);
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        Object result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        context.getApplication().publishEvent(context, PreRemoveFlashValueEvent.class, key);
        result = this.getPhaseMapForWriting().remove(key);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean result = false;
        result = this.getPhaseMapForReading().containsKey(key);
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean result = false;
        result = this.getPhaseMapForReading().containsValue(value);
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        this.getPhaseMapForWriting().putAll(t);
    }

    @Override
    public Collection<Object> values() {
        Collection<Object> result = null;
        result = this.getPhaseMapForReading().values();
        return result;
    }

    @Override
    public int size() {
        int result = 0;
        result = this.getPhaseMapForReading().size();
        return result;
    }

    @Override
    public void clear() {
        this.getPhaseMapForWriting().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> readingMapEntrySet = this.getPhaseMapForReading().entrySet();
        Set<Map.Entry<String, Object>> writingMapEntrySet = this.getPhaseMapForWriting().entrySet();
        HashSet<Map.Entry<String, Object>> result = null;
        result = new HashSet<Map.Entry<String, Object>>();
        result.addAll(readingMapEntrySet);
        result.addAll(writingMapEntrySet);
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean readingMapIsEmpty = this.getPhaseMapForReading().isEmpty();
        boolean writingMapIsEmpty = this.getPhaseMapForWriting().isEmpty();
        boolean result = false;
        result = readingMapIsEmpty && writingMapIsEmpty;
        return result;
    }

    @Override
    public Set<String> keySet() {
        Set<String> readingMapKeySet = this.getPhaseMapForReading().keySet();
        Set<String> writingMapKeySet = this.getPhaseMapForWriting().keySet();
        HashSet<String> result = null;
        result = new HashSet<String>();
        result.addAll(readingMapKeySet);
        result.addAll(writingMapKeySet);
        return result;
    }

    @Override
    public void keep(String key) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
        Map<Object, Object> contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null != flashManager) {
            Object toKeep = requestMap.remove(key);
            if (null == toKeep) {
                FlashInfo flashInfo = null;
                flashInfo = flashManager.getPreviousRequestFlashInfo();
                if (null != flashInfo) {
                    toKeep = flashInfo.getFlashMap().get(key);
                }
            }
            if (null != toKeep) {
                this.getPhaseMapForWriting().put(key, toKeep);
                context.getApplication().publishEvent(context, PostKeepFlashValueEvent.class, key);
            }
        }
    }

    @Override
    public void putNow(String key, Object value) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map<Object, Object> contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null != flashManager) {
            FlashInfo flashInfo = null;
            flashInfo = flashManager.getPreviousRequestFlashInfo();
            if (null != flashInfo) {
                flashInfo.getFlashMap().put(key, value);
            }
        }
    }

    @Override
    public void doPrePhaseActions(FacesContext context) {
        PhaseId currentPhase = context.getCurrentPhaseId();
        Map<Object, Object> contextMap = context.getAttributes();
        contextMap.put((Object)CONSTANTS.SavedResponseCompleteFlagValue, context.getResponseComplete());
        Cookie cookie = null;
        if (currentPhase.equals(PhaseId.RESTORE_VIEW)) {
            cookie = this.getCookie(context.getExternalContext());
            if (null != cookie) {
                this.getCurrentFlashManager(context, contextMap, cookie);
            }
            if (this.isKeepMessages()) {
                this.restoreAllMessages(context);
            }
        } else if (currentPhase.equals(PhaseId.RENDER_RESPONSE) && contextMap.containsKey((Object)WebConfiguration.BooleanWebContextInitParameter.ForceAlwaysWriteFlashCookie) && ((Boolean)contextMap.get((Object)WebConfiguration.BooleanWebContextInitParameter.ForceAlwaysWriteFlashCookie)).booleanValue()) {
            PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
            cookie = flashManager.encode();
            if (null != cookie) {
                this.setCookie(context, flashManager, cookie, true);
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.externalcontext.flash.force.write.cookie.failed");
            }
        }
    }

    @Override
    public void doPostPhaseActions(FacesContext context) {
        boolean lastPhaseForThisRequest;
        if (context.getAttributes().containsKey(ACT_AS_DO_LAST_PHASE_ACTIONS)) {
            Boolean outgoingResponseIsRedirect = (Boolean)context.getAttributes().get(ACT_AS_DO_LAST_PHASE_ACTIONS);
            this.doLastPhaseActions(context, outgoingResponseIsRedirect);
            return;
        }
        PhaseId currentPhase = context.getCurrentPhaseId();
        Map<Object, Object> contextMap = context.getAttributes();
        boolean responseCompleteJustSetTrue = this.responseCompleteWasJustSetTrue(context, contextMap);
        boolean bl = lastPhaseForThisRequest = responseCompleteJustSetTrue || currentPhase == PhaseId.RENDER_RESPONSE;
        if (lastPhaseForThisRequest) {
            this.doLastPhaseActions(context, false);
        }
    }

    public void doLastPhaseActions(FacesContext context, boolean outgoingResponseIsRedirect) {
        Map<Object, Object> contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, false);
        if (null == flashManager) {
            return;
        }
        if (this.isKeepMessages()) {
            this.saveAllMessages(context);
        }
        this.releaseCurrentFlashManager(contextMap);
        if (outgoingResponseIsRedirect) {
            FlashInfo previousRequestFlashInfo = flashManager.getPreviousRequestFlashInfo();
            previousRequestFlashInfo.setIsRedirect(true);
            flashManager.expireNext_MovePreviousToNext();
        } else {
            FlashInfo flashInfo = flashManager.getPreviousRequestFlashInfo();
            if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
                flashManager.expirePrevious();
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "---------------------------------------");
        }
        this.setCookie(context, flashManager, flashManager.encode(), false);
    }

    void setFlashInnerMap(Map<String, Map<String, Object>> flashInnerMap) {
        this.flashInnerMap = flashInnerMap;
    }

    Map<String, Map<String, Object>> getFlashInnerMap() {
        return this.flashInnerMap;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[\n");
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            builder.append("{").append(entry.getKey()).append(", ").append(entry.getValue()).append("}\n");
        }
        builder.append("]\n");
        return builder.toString();
    }

    private void maybeWriteCookie(FacesContext context, PreviousNextFlashInfoManager flashManager) {
        FlashInfo flashInfo = flashManager.getPreviousRequestFlashInfo();
        if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
            PreviousNextFlashInfoManager copiedFlashManager = flashManager.copyWithoutInnerMap();
            copiedFlashManager.expirePrevious();
            this.setCookie(context, flashManager, copiedFlashManager.encode(), false);
        }
    }

    static void setKeepFlag(FacesContext context) {
        context.getAttributes().put((Object)CONSTANTS.KeepFlagAttributeName, Boolean.TRUE);
    }

    void clearKeepFlag(FacesContext context) {
        context.getAttributes().remove((Object)CONSTANTS.KeepFlagAttributeName);
    }

    boolean isKeepFlagSet(FacesContext context) {
        return Boolean.TRUE == context.getAttributes().get((Object)CONSTANTS.KeepFlagAttributeName);
    }

    private long getNewSequenceNumber() {
        long result = this.sequenceNumber.incrementAndGet();
        if (0L == result % this.numberOfFlashesBetweenFlashReapings) {
            this.reapFlashes();
        }
        if (result == Long.MAX_VALUE) {
            result = 1L;
            this.sequenceNumber.set(1L);
        }
        return result;
    }

    private void reapFlashes() {
        ExternalContext extContext;
        SessionHelper sessionHelper;
        if (this.flashInnerMap.size() < this.numberOfConcurentFlashUsers) {
            return;
        }
        Set<String> keys = this.flashInnerMap.keySet();
        long currentSequenceNumber = this.sequenceNumber.get();
        for (String cur : keys) {
            long sequenceNumberToTest = Long.parseLong(cur);
            if ((long)this.numberOfConcurentFlashUsers >= currentSequenceNumber - sequenceNumberToTest) continue;
            Map<String, Object> curFlash = this.flashInnerMap.get(cur);
            if (null != curFlash) {
                curFlash.clear();
            }
            this.flashInnerMap.remove(cur);
        }
        if (this.distributable && FacesContext.getCurrentInstance().getExternalContext().getSession(false) != null && null != (sessionHelper = SessionHelper.getInstance(extContext = FacesContext.getCurrentInstance().getExternalContext()))) {
            sessionHelper.remove(extContext);
            sessionHelper = new SessionHelper();
            sessionHelper.update(extContext, this);
        }
    }

    private boolean responseCompleteWasJustSetTrue(FacesContext context, Map<Object, Object> contextMap) {
        boolean result = false;
        result = Boolean.FALSE == contextMap.get((Object)CONSTANTS.SavedResponseCompleteFlagValue) && context.getResponseComplete();
        return result;
    }

    private static String getLogPrefix(FacesContext context) {
        String viewId;
        UIViewRoot root;
        StringBuilder result = new StringBuilder();
        ExternalContext extContext = context.getExternalContext();
        Object request = extContext.getRequest();
        if (request instanceof HttpServletRequest) {
            result.append(((HttpServletRequest)request).getMethod()).append(" ");
        }
        if (null != (root = context.getViewRoot()) && null != (viewId = root.getViewId())) {
            result.append(viewId).append(" ");
        }
        return result.toString();
    }

    private Map<String, Object> loggingGetPhaseMapForWriting(boolean loggingEnabled) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> result = null;
        PhaseId currentPhase = context.getCurrentPhaseId();
        Map<Object, Object> contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null != flashManager) {
            FlashInfo flashInfo;
            boolean isDebugLog;
            boolean bl = isDebugLog = loggingEnabled && LOGGER.isLoggable(Level.FINEST);
            if (currentPhase.getOrdinal() < PhaseId.RENDER_RESPONSE.getOrdinal()) {
                flashInfo = flashManager.getPreviousRequestFlashInfo();
                if (isDebugLog) {
                    LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(context), flashInfo.getSequenceNumber()});
                }
            } else {
                flashInfo = flashManager.getNextRequestFlashInfo(this, true);
                if (isDebugLog) {
                    LOGGER.log(Level.FINEST, "{0}next[{1}]", new Object[]{ELFlash.getLogPrefix(context), flashInfo.getSequenceNumber()});
                }
                this.maybeWriteCookie(context, flashManager);
            }
            result = flashInfo.getFlashMap();
        }
        return result;
    }

    private Map<String, Object> getPhaseMapForWriting() {
        return this.loggingGetPhaseMapForWriting(true);
    }

    private Map<String, Object> loggingGetPhaseMapForReading(boolean loggingEnabled) {
        FlashInfo flashInfo;
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> result = Collections.emptyMap();
        Map<Object, Object> contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, false);
        if (null != flashManager && null != (flashInfo = flashManager.getPreviousRequestFlashInfo())) {
            boolean isDebugLog;
            boolean bl = isDebugLog = loggingEnabled && LOGGER.isLoggable(Level.FINEST);
            if (isDebugLog) {
                LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(context), flashInfo.getSequenceNumber()});
            }
            result = flashInfo.getFlashMap();
        }
        return result;
    }

    private Map<String, Object> getPhaseMapForReading() {
        return this.loggingGetPhaseMapForReading(true);
    }

    void saveAllMessages(FacesContext context) {
        ArrayList<FacesMessage> facesMessages;
        Iterator<FacesMessage> messageIter;
        Map<Object, Object> contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null == flashManager) {
            return;
        }
        if (flashManager.getPreviousRequestFlashInfo().isIsRedirect()) {
            return;
        }
        Iterator<String> messageClientIds = context.getClientIdsWithMessages();
        HashMap allFacesMessages = null;
        while (messageClientIds.hasNext()) {
            String curMessageId = messageClientIds.next();
            messageIter = context.getMessages(curMessageId);
            facesMessages = new ArrayList();
            while (messageIter.hasNext()) {
                facesMessages.add(messageIter.next());
            }
            if (null == allFacesMessages) {
                allFacesMessages = new HashMap();
            }
            allFacesMessages.put(curMessageId, facesMessages);
        }
        facesMessages = null;
        messageIter = context.getMessages(null);
        facesMessages = new ArrayList<FacesMessage>();
        while (messageIter.hasNext()) {
            facesMessages.add(messageIter.next());
        }
        if (null != facesMessages) {
            if (null == allFacesMessages) {
                allFacesMessages = new HashMap();
            }
            allFacesMessages.put(null, facesMessages);
        }
        this.getPhaseMapForWriting().put(CONSTANTS.FacesMessageAttributeName.toString(), allFacesMessages);
    }

    void restoreAllMessages(FacesContext context) {
        Map<String, Object> phaseMap = this.getPhaseMapForReading();
        Map allFacesMessages = (Map)phaseMap.get(CONSTANTS.FacesMessageAttributeName.toString());
        if (null != allFacesMessages) {
            for (Map.Entry cur : allFacesMessages.entrySet()) {
                List facesMessages = (List)allFacesMessages.get(cur.getKey());
                if (null == facesMessages) continue;
                for (FacesMessage curMessage : facesMessages) {
                    context.addMessage((String)cur.getKey(), curMessage);
                }
            }
            phaseMap.remove(CONSTANTS.FacesMessageAttributeName.toString());
        }
    }

    private Cookie getCookie(ExternalContext extContext) {
        Cookie result = null;
        result = (Cookie)extContext.getRequestCookieMap().get(FLASH_COOKIE_NAME);
        return result;
    }

    private void setCookie(FacesContext context, PreviousNextFlashInfoManager flashManager, Cookie toSet, boolean forceWrite) {
        Map<Object, Object> contextMap = context.getAttributes();
        ExternalContext extContext = context.getExternalContext();
        if (contextMap.containsKey((Object)CONSTANTS.DidWriteCookieAttributeName)) {
            return;
        }
        FlashInfo nextFlash = flashManager.getNextRequestFlashInfo();
        FlashInfo prevFlash = flashManager.getPreviousRequestFlashInfo();
        if (context.getAttributes().containsKey((Object)CONSTANTS.ForceSetMaxAgeZero)) {
            this.removeCookie(extContext, toSet);
            return;
        }
        if (forceWrite || null != nextFlash && !nextFlash.getFlashMap().isEmpty() || null != prevFlash && !prevFlash.getFlashMap().isEmpty()) {
            if (extContext.isResponseCommitted()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.externalcontext.flash.response.already.committed");
                }
                if (nextFlash != null) {
                    flashManager.expireNext();
                }
                if (prevFlash != null) {
                    flashManager.expirePrevious();
                }
            } else {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Object val = toSet.getComment();
                if (null != val) {
                    properties.put("comment", val);
                }
                if (null != (val = toSet.getDomain())) {
                    properties.put("domain", val);
                }
                if (null != (val = Integer.valueOf(toSet.getMaxAge()))) {
                    properties.put("maxAge", val);
                }
                if (extContext.isSecure()) {
                    properties.put("secure", Boolean.TRUE);
                } else {
                    val = toSet.getSecure();
                    if (null != val) {
                        properties.put("secure", val);
                    }
                }
                val = toSet.getPath();
                if (null != val) {
                    properties.put("path", val);
                }
                properties.put("httpOnly", Boolean.TRUE);
                extContext.addResponseCookie(toSet.getName(), toSet.getValue(), !properties.isEmpty() ? properties : null);
                properties = null;
            }
            contextMap.put((Object)CONSTANTS.DidWriteCookieAttributeName, Boolean.TRUE);
        } else {
            this.removeCookie(extContext, toSet);
        }
    }

    private void removeCookie(ExternalContext extContext, Cookie toRemove) {
        if (extContext.isResponseCommitted()) {
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        toRemove.setMaxAge(0);
        Object val = toRemove.getComment();
        if (null != val) {
            properties.put("comment", val);
        }
        if (null != (val = toRemove.getDomain())) {
            properties.put("domain", val);
        }
        if (null != (val = Integer.valueOf(toRemove.getMaxAge()))) {
            properties.put("maxAge", val);
        }
        if (extContext.isSecure()) {
            properties.put("secure", Boolean.TRUE);
        } else {
            val = toRemove.getSecure();
            if (null != val) {
                properties.put("secure", val);
            }
        }
        val = toRemove.getPath();
        if (null != val) {
            properties.put("path", val);
        }
        properties.put("httpOnly", Boolean.TRUE);
        extContext.addResponseCookie(toRemove.getName(), toRemove.getValue(), !properties.isEmpty() ? properties : null);
        properties = null;
    }

    private void releaseCurrentFlashManager(Map<Object, Object> contextMap) {
        contextMap.remove((Object)CONSTANTS.RequestFlashManager);
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(Map<Object, Object> contextMap, boolean create) {
        PreviousNextFlashInfoManager result = (PreviousNextFlashInfoManager)contextMap.get((Object)CONSTANTS.RequestFlashManager);
        if (null == result && create) {
            result = new PreviousNextFlashInfoManager(this.guard, this.flashInnerMap);
            result.initializeBaseCase(this);
            contextMap.put((Object)CONSTANTS.RequestFlashManager, result);
        }
        return result;
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(FacesContext context, Map<Object, Object> contextMap, Cookie cookie) {
        PreviousNextFlashInfoManager result;
        block3: {
            result = (PreviousNextFlashInfoManager)contextMap.get((Object)CONSTANTS.RequestFlashManager);
            if (null == result) {
                result = new PreviousNextFlashInfoManager(this.guard, this.flashInnerMap);
                try {
                    result.decode(context, this, cookie);
                    contextMap.put((Object)CONSTANTS.RequestFlashManager, result);
                }
                catch (InvalidKeyException ike) {
                    contextMap.put((Object)CONSTANTS.ForceSetMaxAgeZero, Boolean.TRUE);
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    result = this.getCurrentFlashManager(contextMap, true);
                    LOGGER.log(Level.SEVERE, "jsf.externalcontext.flash.bad.cookie", new Object[]{ike.getMessage()});
                }
            }
        }
        return result;
    }

    private static final class FlashInfo {
        private boolean isRedirect;
        private LifetimeMarker lifetimeMarker;
        private long sequenceNumber;
        private Map<String, Object> flashMap;

        private FlashInfo() {
        }

        FlashInfo(long sequenceNumber, LifetimeMarker lifetimeMarker, boolean isRedirect) {
            this.setSequenceNumber(sequenceNumber);
            this.setLifetimeMarker(lifetimeMarker);
            this.setIsRedirect(isRedirect);
        }

        FlashInfo copyWithoutInnerMap() {
            FlashInfo result = new FlashInfo(this.sequenceNumber, this.lifetimeMarker, this.isRedirect);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlashInfo other = (FlashInfo)obj;
            if (this.isRedirect != other.isRedirect) {
                return false;
            }
            if (!(this.lifetimeMarker == other.lifetimeMarker || this.lifetimeMarker != null && this.lifetimeMarker.equals((Object)other.lifetimeMarker))) {
                return false;
            }
            return this.sequenceNumber == other.sequenceNumber;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.isRedirect ? 1 : 0);
            hash = 71 * hash + (this.lifetimeMarker != null ? this.lifetimeMarker.hashCode() : 0);
            hash = 71 * hash + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
            return hash;
        }

        void decode(String value) {
            if (null == value || 0 == value.length()) {
                return;
            }
            int i = value.indexOf(88);
            this.setSequenceNumber(Long.parseLong(value.substring(0, i++)));
            this.setLifetimeMarker(LifetimeMarker.decode(value.charAt(i++)));
            this.setIsRedirect(LifetimeMarker.IsRedirect == LifetimeMarker.decode(value.charAt(i++)));
        }

        String encode() {
            String value = null;
            value = this.isIsRedirect() ? Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsRedirect.encode() : Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsNormal.encode();
            return value;
        }

        boolean isIsRedirect() {
            return this.isRedirect;
        }

        void setIsRedirect(boolean isRedirect) {
            this.isRedirect = isRedirect;
        }

        long getSequenceNumber() {
            return this.sequenceNumber;
        }

        void setSequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        LifetimeMarker getLifetimeMarker() {
            return this.lifetimeMarker;
        }

        void setLifetimeMarker(LifetimeMarker lifetimeMarker) {
            this.lifetimeMarker = lifetimeMarker;
        }

        Map<String, Object> getFlashMap() {
            return this.flashMap;
        }

        void setFlashMap(Map<String, Object> flashMap) {
            this.flashMap = flashMap;
        }
    }

    private static final class PreviousNextFlashInfoManager {
        private FlashInfo previousRequestFlashInfo;
        private FlashInfo nextRequestFlashInfo;
        private boolean incomingCookieCameFromRedirect = false;
        private Map<String, Map<String, Object>> innerMap;
        private ByteArrayGuardAESCTR guard;

        private PreviousNextFlashInfoManager(ByteArrayGuardAESCTR guard) {
            this.guard = guard;
        }

        private PreviousNextFlashInfoManager(ByteArrayGuardAESCTR guard, Map<String, Map<String, Object>> innerMap) {
            this.guard = guard;
            this.innerMap = innerMap;
        }

        protected PreviousNextFlashInfoManager copyWithoutInnerMap() {
            PreviousNextFlashInfoManager result = new PreviousNextFlashInfoManager(this.guard);
            result.innerMap = Collections.emptyMap();
            if (null != this.previousRequestFlashInfo) {
                result.previousRequestFlashInfo = this.previousRequestFlashInfo.copyWithoutInnerMap();
            }
            if (null != this.nextRequestFlashInfo) {
                result.nextRequestFlashInfo = this.nextRequestFlashInfo.copyWithoutInnerMap();
            }
            result.incomingCookieCameFromRedirect = this.incomingCookieCameFromRedirect;
            return result;
        }

        public String toString() {
            String result = null;
            result = "previousRequestSequenceNumber: " + (null != this.previousRequestFlashInfo ? Long.valueOf(this.previousRequestFlashInfo.getSequenceNumber()) : "null") + " nextRequestSequenceNumber: " + (null != this.nextRequestFlashInfo ? Long.valueOf(this.nextRequestFlashInfo.getSequenceNumber()) : "null");
            return result;
        }

        void initializeBaseCase(ELFlash flash) {
            HashMap<String, Object> flashMap = null;
            this.previousRequestFlashInfo = new FlashInfo(flash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            flashMap = new HashMap<String, Object>();
            this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", flashMap);
            this.previousRequestFlashInfo.setFlashMap(flashMap);
            this.nextRequestFlashInfo = new FlashInfo(flash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            flashMap = new HashMap();
            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", flashMap);
            this.nextRequestFlashInfo.setFlashMap(flashMap);
        }

        void expirePrevious() {
            if (null != this.previousRequestFlashInfo) {
                Map<String, Object> flashMap = this.previousRequestFlashInfo.getFlashMap();
                if (null != flashMap) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "{0} expire previous[{1}]", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.previousRequestFlashInfo.getSequenceNumber()});
                    }
                    FacesContext context = FacesContext.getCurrentInstance();
                    context.getApplication().publishEvent(context, PreClearFlashEvent.class, flashMap);
                    flashMap.clear();
                }
                this.innerMap.remove(this.previousRequestFlashInfo.getSequenceNumber() + "");
                this.previousRequestFlashInfo = null;
            }
        }

        void expireNext() {
            if (null != this.nextRequestFlashInfo) {
                Map<String, Object> flashMap = this.nextRequestFlashInfo.getFlashMap();
                if (null != flashMap) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "{0} expire next[{1}]", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.nextRequestFlashInfo.getSequenceNumber()});
                    }
                    FacesContext context = FacesContext.getCurrentInstance();
                    context.getApplication().publishEvent(context, PreClearFlashEvent.class, flashMap);
                    flashMap.clear();
                }
                this.innerMap.remove(this.nextRequestFlashInfo.getSequenceNumber() + "");
                this.nextRequestFlashInfo = null;
            }
        }

        void expireNext_MovePreviousToNext() {
            if (null != this.nextRequestFlashInfo) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "{0} expire next[{1}], move previous to next", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.nextRequestFlashInfo.getSequenceNumber()});
                }
                Map<String, Object> flashMap = this.nextRequestFlashInfo.getFlashMap();
                FacesContext context = FacesContext.getCurrentInstance();
                context.getApplication().publishEvent(context, PreClearFlashEvent.class, flashMap);
                flashMap.clear();
                this.innerMap.remove(this.nextRequestFlashInfo.getSequenceNumber() + "");
                this.nextRequestFlashInfo = null;
            }
            this.nextRequestFlashInfo = this.previousRequestFlashInfo;
            this.previousRequestFlashInfo = null;
        }

        void decode(FacesContext context, ELFlash flash, Cookie cookie) throws InvalidKeyException {
            block11: {
                String urlDecodedValue = null;
                try {
                    urlDecodedValue = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    urlDecodedValue = cookie.getValue();
                }
                String value = this.guard.decrypt(urlDecodedValue);
                try {
                    int i = value.indexOf("_");
                    String temp = value.substring(0, i++);
                    if (0 < temp.length()) {
                        this.nextRequestFlashInfo = new FlashInfo();
                        this.nextRequestFlashInfo.decode(temp);
                    }
                    this.previousRequestFlashInfo = new FlashInfo();
                    this.previousRequestFlashInfo.decode(value.substring(i));
                    if (this.previousRequestFlashInfo.isIsRedirect()) {
                        this.setIncomingCookieCameFromRedirect(true);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                    } else if (!UIDebug.debugRequest(context)) {
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.SecondTimeThru);
                        this.expireNext();
                    }
                    Map<String, Object> flashMap = this.innerMap.get(this.previousRequestFlashInfo.getSequenceNumber() + "");
                    if (null == flashMap) {
                        this.previousRequestFlashInfo = new FlashInfo();
                        this.previousRequestFlashInfo.setSequenceNumber(flash.getNewSequenceNumber());
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                        flashMap = new HashMap<String, Object>();
                        this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", flashMap);
                    }
                    this.previousRequestFlashInfo.setFlashMap(flashMap);
                    if (null != this.nextRequestFlashInfo) {
                        flashMap = this.innerMap.get(this.nextRequestFlashInfo.getSequenceNumber() + "");
                        if (null == flashMap) {
                            this.nextRequestFlashInfo = new FlashInfo();
                            this.nextRequestFlashInfo.setSequenceNumber(flash.getNewSequenceNumber());
                            this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                            this.nextRequestFlashInfo.setIsRedirect(false);
                            flashMap = new HashMap<String, Object>();
                            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", flashMap);
                        }
                        this.nextRequestFlashInfo.setFlashMap(flashMap);
                    }
                }
                catch (Throwable t) {
                    context.getAttributes().put((Object)CONSTANTS.ForceSetMaxAgeZero, Boolean.TRUE);
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                    LOGGER.log(Level.SEVERE, "jsf.externalcontext.flash.bad.cookie", new Object[]{value});
                }
            }
        }

        Cookie encode() {
            String requestContextPath;
            Cookie result = null;
            String value = (null != this.previousRequestFlashInfo ? this.previousRequestFlashInfo.encode() : "") + "_" + (null != this.nextRequestFlashInfo ? this.nextRequestFlashInfo.encode() : "");
            String encryptedValue = this.guard.encrypt(value);
            try {
                result = new Cookie(ELFlash.FLASH_COOKIE_NAME, URLEncoder.encode(encryptedValue, "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                result = new Cookie(ELFlash.FLASH_COOKIE_NAME, encryptedValue);
            }
            if (1 == value.length()) {
                result.setMaxAge(0);
            }
            if ((requestContextPath = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath()).isEmpty()) {
                requestContextPath = "/";
            }
            result.setPath(requestContextPath);
            return result;
        }

        FlashInfo getPreviousRequestFlashInfo() {
            return this.previousRequestFlashInfo;
        }

        void setPreviousRequestFlashInfo(FlashInfo thisRequestFlashInfo) {
            this.previousRequestFlashInfo = thisRequestFlashInfo;
        }

        FlashInfo getNextRequestFlashInfo() {
            return this.nextRequestFlashInfo;
        }

        FlashInfo getNextRequestFlashInfo(ELFlash flash, boolean create) {
            if (create && null == this.nextRequestFlashInfo) {
                this.nextRequestFlashInfo = new FlashInfo();
                this.nextRequestFlashInfo.setSequenceNumber(flash.getNewSequenceNumber());
                this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                this.nextRequestFlashInfo.setIsRedirect(false);
                HashMap<String, Object> flashMap = null;
                flashMap = new HashMap<String, Object>();
                this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", flashMap);
                this.nextRequestFlashInfo.setFlashMap(flashMap);
            }
            return this.nextRequestFlashInfo;
        }

        void setNextRequestFlashInfo(FlashInfo nextRequestFlashInfo) {
            this.nextRequestFlashInfo = nextRequestFlashInfo;
        }

        boolean isIncomingCookieCameFromRedirect() {
            return this.incomingCookieCameFromRedirect;
        }

        void setIncomingCookieCameFromRedirect(boolean incomingCookieCameFromRedirect) {
            this.incomingCookieCameFromRedirect = incomingCookieCameFromRedirect;
        }
    }

    private static enum LifetimeMarker {
        FirstTimeThru("f"),
        SecondTimeThru("s"),
        IsRedirect("r"),
        IsNormal("n");

        private static char FIRST_TIME_THRU;
        private static char SECOND_TIME_THRU;
        private static char IS_REDIRECT;
        private static char IS_NORMAL;
        private String name;

        private LifetimeMarker(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public char encode() {
            return this.name.charAt(0);
        }

        public static LifetimeMarker decode(char c) {
            LifetimeMarker result = FirstTimeThru;
            if (FIRST_TIME_THRU == c) {
                result = FirstTimeThru;
            } else if (SECOND_TIME_THRU == c) {
                result = SecondTimeThru;
            } else if (IS_REDIRECT == c) {
                result = IsRedirect;
            } else if (IS_NORMAL == c) {
                result = IsNormal;
            } else {
                throw new IllegalStateException("class invariant failed: invalid lifetime marker");
            }
            return result;
        }

        static {
            FIRST_TIME_THRU = (char)102;
            SECOND_TIME_THRU = (char)115;
            IS_REDIRECT = (char)114;
            IS_NORMAL = (char)110;
        }
    }

    private static enum CONSTANTS {
        RequestFlashManager,
        SavedResponseCompleteFlagValue,
        FacesMessageAttributeName,
        KeepAllMessagesAttributeName,
        KeepFlagAttributeName,
        DidWriteCookieAttributeName,
        ForceSetMaxAgeZero;

    }
}

