/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.auth.login;

import com.sun.enterprise.security.PrincipalGroupFactory;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.ee.auth.login.DigestCredentials;
import com.sun.enterprise.security.ee.auth.realm.DigestRealm;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;

public abstract class DigestLoginModule
implements LoginModule {
    private Subject subject = null;
    private CallbackHandler handler = null;
    private Map<String, ?> sharedState = null;
    private Map<String, ?> options = null;
    protected static final Logger _logger = LogDomains.getLogger(DigestLoginModule.class, (String)"javax.enterprise.system.core.security");
    protected boolean _succeeded = false;
    protected boolean _commitSucceeded = false;
    protected PrincipalImpl _userPrincipal;
    private DigestCredentials digestCredentials = null;
    private Realm _realm;

    @Override
    public final void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = handler;
        this.sharedState = sharedState;
        this.options = options;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Login module initialized: " + this.getClass().toString());
        }
    }

    @Override
    public final boolean login() throws LoginException {
        Set<Object> creds = this.subject.getPrivateCredentials();
        for (Object obj : creds) {
            if (obj instanceof DigestCredentials) {
                this.digestCredentials = (DigestCredentials)obj;
                break;
            }
            if (!(obj instanceof com.sun.enterprise.security.auth.login.DigestCredentials)) continue;
            com.sun.enterprise.security.auth.login.DigestCredentials dc = (com.sun.enterprise.security.auth.login.DigestCredentials)obj;
            this.digestCredentials = new DigestCredentials(dc.getRealmName(), dc.getUserName(), dc.getParameters());
        }
        if (this.digestCredentials == null) {
            throw new LoginException();
        }
        DigestAlgorithmParameter[] params = this.digestCredentials.getParameters();
        String username = this.digestCredentials.getUserName();
        try {
            this._realm = Realm.getInstance(this.digestCredentials.getRealmName());
        }
        catch (NoSuchRealmException ex) {
            _logger.log(Level.FINE, "", ex);
            _logger.log(Level.SEVERE, "no.realm", this.digestCredentials.getRealmName());
            throw new LoginException(ex.getMessage());
        }
        if (!(this._realm instanceof DigestRealm)) {
            _logger.log(Level.SEVERE, "digest.realm", this.digestCredentials.getRealmName());
            throw new LoginException("Realm" + this.digestCredentials.getRealmName() + " does not support Digest validation");
        }
        if (((DigestRealm)((Object)this._realm)).validate(username, params)) {
            this._succeeded = true;
        }
        return this._succeeded;
    }

    @Override
    public final boolean commit() throws LoginException {
        if (!this._succeeded) {
            this._commitSucceeded = false;
            return false;
        }
        PrincipalGroupFactory factory = Globals.getDefaultHabitat().getService(PrincipalGroupFactory.class, new Annotation[0]);
        this._userPrincipal = factory.getPrincipalInstance(this.digestCredentials.getUserName(), this.digestCredentials.getRealmName());
        Set<Principal> principalSet = this.subject.getPrincipals();
        if (!principalSet.contains(this._userPrincipal)) {
            principalSet.add((Principal)this._userPrincipal);
        }
        Enumeration groupsList = this.getGroups(this.digestCredentials.getUserName());
        while (groupsList.hasMoreElements()) {
            String value = (String)groupsList.nextElement();
            Group g = factory.getGroupInstance(value, this.digestCredentials.getRealmName());
            if (principalSet.contains(g)) continue;
            principalSet.add((Principal)g);
        }
        return true;
    }

    @Override
    public final boolean abort() throws LoginException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JAAS authentication aborted.");
        }
        if (!this._succeeded) {
            return false;
        }
        if (this._succeeded && !this._commitSucceeded) {
            this._succeeded = false;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public final boolean logout() throws LoginException {
        this.subject.getPrincipals().clear();
        this.subject.getPublicCredentials().clear();
        this.subject.getPrivateCredentials().clear();
        this._succeeded = false;
        this._commitSucceeded = false;
        return true;
    }

    protected Realm getRealm() {
        return this._realm;
    }

    protected abstract Enumeration getGroups(String var1);
}

