/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValueAccessStrategyTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ValueAccessStrategyTest.webArchiveBuilder().withTestClass(ValueAccessStrategyTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-constraintdeclaration", id="a")
    public void testValidatedObjectIsPassedToValidatorOfClassLevelConstraint() {
        Person person = new Person();
        this.getValidator().validate((Object)person, new Class[0]);
        Assert.assertEquals((Object)ValidPerson.ValidPersonValidator.validatedValue, (Object)person);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-constraintdeclaration", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a")})
    public void testValueFromFieldIsPassedToValidatorOfFieldLevelConstraint() {
        Person person = new Person();
        this.getValidator().validate((Object)person, new Class[0]);
        Assert.assertEquals((String)ValidFirstName.ValidFirstNameValidator.validatedValue, (String)"Bob", (String)"Expected value to be retrieved from field.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-constraintdeclaration", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine", id="a")})
    public void testValueFromGetterIsPassedToValidatorOfPropertyLevelConstraint() {
        Person person = new Person();
        this.getValidator().validate((Object)person, new Class[0]);
        Assert.assertEquals((String)ValidName.Validator.validatedValue, (String)"Billy", (String)"Expected value to be retrieved from getter.");
    }

    @Constraint(validatedBy={Validator.class})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidName {
        public String message() default "{ValidFirstName.message}";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<ValidName, String> {
            private static String validatedValue;

            public boolean isValid(String value, ConstraintValidatorContext context) {
                validatedValue = value;
                return false;
            }
        }
    }

    @Constraint(validatedBy={ValidFirstNameValidator.class})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidFirstName {
        public String message() default "{ValidFirstName.message}";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class ValidFirstNameValidator
        implements ConstraintValidator<ValidFirstName, String> {
            private static String validatedValue;

            public boolean isValid(String value, ConstraintValidatorContext context) {
                validatedValue = value;
                return false;
            }
        }
    }

    @Constraint(validatedBy={ValidPersonValidator.class})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidPerson {
        public String message() default "{ValidPerson.message}";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class ValidPersonValidator
        implements ConstraintValidator<ValidPerson, Person> {
            private static Person validatedValue;

            public boolean isValid(Person value, ConstraintValidatorContext context) {
                validatedValue = value;
                return false;
            }
        }
    }

    @ValidPerson
    private static class Person {
        @ValidFirstName
        private final String firstName = "Bob";

        private Person() {
        }

        @ValidName
        public String getFirstName() {
            return "Billy";
        }
    }
}

