/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.BadlyBehavedEntity;
import org.hibernate.beanvalidation.tck.tests.validation.Customer;
import org.hibernate.beanvalidation.tck.tests.validation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.Person;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidatePropertyTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)ValidatePropertyTest.webArchiveBuilder().withTestClass(ValidatePropertyTest.class)).withClasses(Customer.class, Person.class, Order.class, Address.class, BadlyBehavedEntity.class)).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="e")
    public void testPassingNullAsGroup() {
        Customer customer = new Customer();
        this.getValidator().validateProperty((Object)customer, "firstName", new Class[]{null});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="e")
    public void testIllegalArgumentExceptionIsThrownForNullValue() {
        this.getValidator().validateProperty(null, "firstName", new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-validationmethods", id="e"), @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="f")})
    public void testValidatePropertyWithInvalidPropertyPath() {
        Customer customer = new Customer();
        try {
            this.getValidator().validateProperty((Object)customer, "foobar", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.getValidator().validateProperty((Object)customer, "FirstName", new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="e")
    public void testValidatePropertyWithNullProperty() {
        Customer customer = new Customer();
        this.getValidator().validateProperty((Object)customer, null, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="e")
    public void testValidatePropertyWithEmptyProperty() {
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        this.getValidator().validateProperty((Object)customer, "", new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-validatorapi-validationmethods", id="c"), @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="d"), @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="e"), @SpecAssertion(section="validationapi-constraintviolation", id="f"), @SpecAssertion(section="validationapi-constraintviolation", id="g"), @SpecAssertion(section="validationapi-constraintviolation", id="h"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void testValidateProperty() {
        Address address = new Address();
        address.setStreet(null);
        address.setZipCode(null);
        String townInNorthWales = "Llanfairpwllgwyngyllgogerychwyrndrobwyll-llantysiliogogogoch";
        address.setCity(townInNorthWales);
        Set constraintViolations = this.getValidator().validateProperty((Object)address, "city", new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        ConstraintViolationAssert.assertCorrectConstraintTypes(constraintViolations, Size.class);
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        ConstraintViolationAssert.assertConstraintViolation(violation, Address.class, townInNorthWales, ConstraintViolationAssert.pathWith().property("city"));
        Assert.assertEquals((Object)violation.getRootBean(), (Object)address);
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)address);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)townInNorthWales);
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertNull((Object)violation.getExecutableReturnValue());
        ConstraintViolationAssert.assertCorrectConstraintViolationMessages(constraintViolations, "City name cannot be longer than 30 characters.");
        address.setCity("London");
        constraintViolations = this.getValidator().validateProperty((Object)address, "city", new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="g")
    public void testValidIsNotHonoredValidateProperty() {
        Customer customer = new Customer();
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = this.getValidator().validateProperty((Object)customer, "orders", new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="validationapi-validatorapi-validationmethods", id="k")
    public void testUnexpectedExceptionsInValidatePropertyGetWrappedInValidationExceptions() {
        this.getValidator().validateProperty((Object)new BadlyBehavedEntity(), "value", new Class[0]);
    }
}

