/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.ContainerElementTypeDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.BasicChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexProductTypeChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.MetaDataTestUtil;
import org.hibernate.beanvalidation.tck.tests.metadata.ProductOrderLine;
import org.hibernate.beanvalidation.tck.tests.metadata.ProductType;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ParameterDescriptorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ParameterDescriptorTest.webArchiveBuilder().withTestClassPackage(ParameterDescriptorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertEquals((Object)((ParameterDescriptor)parameters.get(0)).getElementClass(), String.class, (String)"Wrong parameter class");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClassForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertEquals((Object)((ParameterDescriptor)parameters.get(0)).getElementClass(), String.class, (String)"Wrong parameter class");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="a")
    public void testGetIndexForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(0)).getIndex(), (int)0, (String)"Wrong parameter index");
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(1)).getIndex(), (int)1, (String)"Wrong parameter index");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="a")
    public void testGetIndexForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(0)).getIndex(), (int)0, (String)"Wrong parameter index");
        Assert.assertEquals((int)((ParameterDescriptor)parameters.get(1)).getIndex(), (int)1, (String)"Wrong parameter index");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="b")
    public void testGetNameForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(0)).getName(), (String)"firstName", (String)"Wrong parameter name");
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(1)).getName(), (String)"lastName", (String)"Wrong parameter name");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-parameterdescriptor", id="b")
    public void testGetNameForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(0)).getName(), (String)"firstName", (String)"Wrong parameter name");
        Assert.assertEquals((String)((ParameterDescriptor)parameters.get(1)).getName(), (String)"lastName", (String)"Wrong parameter name");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForMethod() {
        List parameters = Executables.parameterConstrainedMethod().getParameterDescriptors();
        Assert.assertFalse((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should not be cascaded");
        parameters = Executables.cascadedParameterMethod().getParameterDescriptors();
        Assert.assertTrue((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascadedForConstructor() {
        List parameters = Executables.parameterConstrainedConstructor().getParameterDescriptors();
        Assert.assertFalse((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should not be cascaded");
        parameters = Executables.cascadedParameterConstructor().getParameterDescriptors();
        Assert.assertTrue((boolean)((ParameterDescriptor)parameters.get(0)).isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForConstructorParameter() {
        List parameters = Executables.constructorWithGroupConversionOnParameter().getParameterDescriptors();
        Set groupConversions = ((ParameterDescriptor)parameters.get(1)).getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForMethodParameter() {
        List parameters = Executables.methodWithGroupConversionOnParameter().getParameterDescriptors();
        Set groupConversions = ((ParameterDescriptor)parameters.get(0)).getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(CustomerService.StrictCustomerServiceChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), CustomerService.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForConstructorParameter() {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)Executables.parameterConstrainedConstructor().getParameterDescriptors().get(0);
        Set groupConversions = parameterDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySetForMethodParameter() {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)Executables.parameterConstrainedMethod().getParameterDescriptors().get(0);
        Set groupConversions = parameterDescriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d")})
    public void testGetContainerElementMetaDataForMethodParameter() {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)Executables.parameterWithCascadedContainerElements().getParameterDescriptors().get(1);
        this.checkContainerElementMetaDataOnParameterDescriptor(parameterDescriptor);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="e")})
    public void testGetContainerElementMetaDataForConstructorParameter() {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)Executables.constructorWithCascadedContainerElementsOnParameter().getParameterDescriptors().get(0);
        this.checkContainerElementMetaDataOnParameterDescriptor(parameterDescriptor);
    }

    private void checkContainerElementMetaDataOnParameterDescriptor(ParameterDescriptor parameterDescriptor) {
        Set containerElementTypes = parameterDescriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypes.size(), (int)2);
        ContainerElementTypeDescriptor productType = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypes, Map.class, 0);
        Assert.assertEquals((Object)productType.getElementClass(), ProductType.class);
        MetaDataTestUtil.assertConstraintDescriptors(productType.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)productType.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertTrue((boolean)productType.isCascaded());
        Assert.assertEquals((int)productType.getGroupConversions().size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : productType.getGroupConversions()) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(ComplexChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ComplexProductTypeChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
        ContainerElementTypeDescriptor orderLineList = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypes, Map.class, 1);
        Assert.assertEquals((Object)orderLineList.getElementClass(), List.class);
        MetaDataTestUtil.assertConstraintDescriptors(orderLineList.getConstraintDescriptors(), Size.class);
        Assert.assertFalse((boolean)orderLineList.isCascaded());
        Assert.assertEquals((int)orderLineList.getGroupConversions().size(), (int)0);
        Assert.assertEquals((int)orderLineList.getConstrainedContainerElementTypes().size(), (int)1);
        ContainerElementTypeDescriptor orderLine = MetaDataTestUtil.getContainerElementDescriptor(orderLineList.getConstrainedContainerElementTypes(), List.class, 0);
        Assert.assertEquals((Object)orderLine.getElementClass(), ProductOrderLine.class);
        MetaDataTestUtil.assertConstraintDescriptors(orderLine.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)orderLine.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertFalse((boolean)orderLine.isCascaded());
    }
}

