/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.spi.context;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.core.spi.context.Context;
import org.jboss.arquillian.core.spi.context.IdBoundContext;
import org.jboss.arquillian.core.spi.context.ObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext<T>
implements Context,
IdBoundContext<T> {
    private static Logger log = Logger.getLogger("Context");
    private ConcurrentHashMap<T, ObjectStore> stores;
    private ThreadLocal<Stack<StoreHolder<T>>> activeStore = new ThreadLocal<Stack<StoreHolder<T>>>(){

        @Override
        protected Stack<StoreHolder<T>> initialValue() {
            return new Stack();
        }
    };

    public AbstractContext() {
        this.stores = new ConcurrentHashMap();
    }

    @Override
    public T getActiveId() {
        if (this.isActive()) {
            return this.activeStore.get().peek().getId();
        }
        return null;
    }

    @Override
    public void activate(T id) {
        Validate.notNull(id, "ID must be specified");
        this.activeStore.get().push(new StoreHolder<T>(id, this.createObjectStore(id)));
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            this.activeStore.get().pop();
        } else {
            log.info("Trying to deactivate context, but none active: " + super.getClass().getSimpleName());
        }
    }

    public void deactivateAll() {
        if (this.isActive()) {
            this.activeStore.get().clear();
        }
    }

    @Override
    public boolean isActive() {
        return !this.activeStore.get().isEmpty();
    }

    @Override
    public void destroy(T id) {
        ObjectStore store = this.stores.remove(id);
        if (store != null) {
            store.clear();
        }
    }

    @Override
    public ObjectStore getObjectStore() {
        if (this.isActive()) {
            return this.activeStore.get().peek().getStore();
        }
        throw new RuntimeException("Context is not active: " + super.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        AbstractContext abstractContext = this;
        synchronized (abstractContext) {
            if (this.isActive()) {
                this.deactivateAll();
            }
            this.activeStore.remove();
            for (Map.Entry<T, ObjectStore> entry : this.stores.entrySet()) {
                entry.getValue().clear();
            }
            this.stores.clear();
        }
    }

    protected abstract ObjectStore createNewObjectStore();

    private ObjectStore createObjectStore(T id) {
        Validate.notNull(id, "ID must be specified");
        ObjectStore store = this.createNewObjectStore();
        ObjectStore previousStore = this.stores.putIfAbsent(id, store);
        if (previousStore != null) {
            return previousStore;
        }
        return store;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoreHolder<X> {
        private X id;
        private ObjectStore store;

        public StoreHolder(X id, ObjectStore store) {
            this.id = id;
            this.store = store;
        }

        public X getId() {
            return this.id;
        }

        public ObjectStore getStore() {
            return this.store;
        }
    }
}

