/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.java.jtopen;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import eglx.jtopen.IBMiConnection;
import eglx.jtopen.JTOpenConnection;
import eglx.lang.InvocationException;
import java.io.IOException;
import org.eclipse.edt.java.jtopen.AS400Converter;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.resources.ExecutableBase;

public class IBMiProgramCall {
    private static final long serialVersionUID = 1L;

    public static Integer ezeRunProgram(String library, String programName, String procedureName, boolean isServiceProgram, boolean hasReturn, ParameterTypeKind[] parameterTypeKinds, Object[] parameters, AS400DataType[] ezeAS400DataConverters, IBMiConnection connection, String methodName, ExecutableBase caller) {
        try {
            if (connection == null || connection.getAS400() == null) {
                InvocationException ex = new InvocationException();
                ex.setName(programName);
                ex.setMessage("Host connection is null.");
                throw ex;
            }
        }
        catch (Exception e) {
            IBMiProgramCall.throwInvocationException(programName, e);
        }
        Class[] parameterTypes = new Class[parameters.length];
        int idx = 0;
        while (idx < parameters.length) {
            parameterTypes[idx] = parameters[idx].getClass();
            ++idx;
        }
        String hostLibrary = library;
        if (connection instanceof JTOpenConnection && connection.getLibrary() != null && !connection.getLibrary().isEmpty()) {
            hostLibrary = connection.getLibrary();
        }
        String slash = hostLibrary != null && !hostLibrary.isEmpty() ? "/" : "";
        boolean hostLibraryHasSlash = false;
        if (hostLibrary != null && !hostLibrary.isEmpty() && hostLibrary.charAt(hostLibrary.length() - 1) == '/') {
            slash = "";
            hostLibraryHasSlash = true;
        }
        if (programName != null && !programName.isEmpty() && programName.charAt(0) == '/') {
            slash = "";
            if (hostLibraryHasSlash) {
                hostLibrary = hostLibrary.substring(0, hostLibrary.length() - 1);
            }
        }
        hostLibrary = String.valueOf(hostLibrary) + slash;
        ServiceProgramCall ezeCall = null;
        try {
            if (isServiceProgram) {
                ezeCall = new ServiceProgramCall(connection.getAS400());
                ezeCall.setProgram(String.valueOf(hostLibrary) + programName);
                ezeCall.setProcedureName(procedureName);
            } else {
                ezeCall = new ProgramCall(connection.getAS400());
                ezeCall.setProgram(String.valueOf(hostLibrary) + programName);
            }
            int idx2 = 0;
            while (idx2 < parameters.length) {
                if (parameterTypeKinds[idx2] == ParameterTypeKind.IN) {
                    ezeCall.addParameter(new ProgramParameter(1, ezeAS400DataConverters[idx2].toBytes(AS400Converter.convertToObjects(parameters[idx2], ezeAS400DataConverters[idx2])), 0));
                } else if (parameterTypeKinds[idx2] == ParameterTypeKind.INOUT) {
                    ezeCall.addParameter(new ProgramParameter(2, ezeAS400DataConverters[idx2].toBytes(AS400Converter.convertToObjects(parameters[idx2], ezeAS400DataConverters[idx2])), ezeAS400DataConverters[idx2].getByteLength()));
                } else {
                    ezeCall.addParameter(new ProgramParameter(2, new byte[0], ezeAS400DataConverters[idx2].getByteLength()));
                }
                ++idx2;
            }
        }
        catch (Exception e) {
            IBMiProgramCall.throwInvocationException(programName, e);
        }
        try {
            if (!ezeCall.run()) {
                AS400Message[] messagelist = ezeCall.getMessageList();
                StringBuilder buf = new StringBuilder();
                int idx3 = 0;
                while (idx3 < messagelist.length) {
                    if (idx3 > 0) {
                        buf.append("\n");
                    }
                    buf.append(messagelist[idx3].getID());
                    buf.append(":");
                    buf.append(messagelist[idx3].getText());
                    buf.append("\n");
                    buf.append(messagelist[idx3].getHelp());
                    ++idx3;
                }
                InvocationException ex = new InvocationException();
                ex.setName(programName);
                ex.setMessage(buf.toString());
                throw ex;
            }
        }
        catch (AS400SecurityException e) {
            e.printStackTrace();
            IBMiProgramCall.throwInvocationException(programName, (Exception)((Object)e));
        }
        catch (ErrorCompletingRequestException e) {
            e.printStackTrace();
            IBMiProgramCall.throwInvocationException(programName, (Exception)((Object)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            IBMiProgramCall.throwInvocationException(programName, e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            IBMiProgramCall.throwInvocationException(programName, e);
        }
        catch (ObjectDoesNotExistException e) {
            e.printStackTrace();
            IBMiProgramCall.throwInvocationException(programName, (Exception)((Object)e));
        }
        int idx4 = 0;
        while (idx4 < parameters.length) {
            if (parameterTypeKinds[idx4] != ParameterTypeKind.IN) {
                if (parameters[idx4] instanceof AnyBoxedObject) {
                    AS400Converter.convertFromAS400(parameters[idx4], ezeAS400DataConverters[idx4].toObject(ezeCall.getParameterList()[idx4].getOutputData()));
                } else {
                    parameters[idx4] = AS400Converter.convertFromAS400(parameters[idx4], ezeAS400DataConverters[idx4].toObject(ezeCall.getParameterList()[idx4].getOutputData()));
                }
            }
            ++idx4;
        }
        if (hasReturn) {
            return (Integer)new AS400Bin4().toObject(ezeCall.getReturnValue());
        }
        return null;
    }

    protected static void throwInvocationException(String programName, Exception e) {
        InvocationException ex = new InvocationException();
        ex.setName(programName);
        ex.setMessage(String.valueOf(e.getClass().getName()) + ":" + e.getLocalizedMessage());
        throw ex;
    }

    public static enum ParameterTypeKind {
        IN,
        INOUT,
        OUT;

    }
}

