/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.ide;

import eglx.lang.AnyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;
import resources.edt.binding.BindingResourceProcessor;
import resources.edt.binding.RuntimeResourceLocator;

public class IDEResourceLocator
extends RuntimeResourceLocator {
    private Map<String, String> ddPaths = new HashMap<String, String>();
    private Method ddParserMethod;

    public void setDDParser(Method method) {
        this.ddParserMethod = method;
    }

    @Override
    public RuntimeDeploymentDesc getDeploymentDesc(URI propertyFileUri) {
        RuntimeDeploymentDesc dd = this.getDeploymentDesc(propertyFileUri.toString());
        if (dd == null) {
            return super.getDeploymentDesc(propertyFileUri);
        }
        return dd;
    }

    public RuntimeDeploymentDesc getDeploymentDesc(String propertyFileName) {
        String path;
        String normalized = this.normalizePropertyFileName(propertyFileName);
        RuntimeDeploymentDesc dd = (RuntimeDeploymentDesc)deploymentDescs.get(normalized);
        if (dd == null && (path = this.ddPaths.get(normalized)) != null && path.length() > 0) {
            try {
                FileInputStream is = new FileInputStream(new File(path));
                dd = this.ddParserMethod == null ? RuntimeDeploymentDesc.createDeploymentDescriptor(normalized, is) : (RuntimeDeploymentDesc)this.ddParserMethod.invoke(null, normalized, is);
                deploymentDescs.put(normalized, dd);
            }
            catch (Exception e) {
                AnyException ex = new AnyException();
                throw ex.fillInMessage("EGL0042E", new Object[]{propertyFileName, e});
            }
        }
        return dd;
    }

    public String normalizePropertyFileName(String name) {
        int lastSlash;
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.startsWith("file:")) {
            name = name.substring(5);
        }
        if ((lastSlash = name.lastIndexOf(47)) != -1) {
            name = name.substring(lastSlash + 1);
        }
        if (name.endsWith("-bnd.xml")) {
            name = name.substring(0, name.length() - 8);
        } else if (name.endsWith(".egldd")) {
            name = name.substring(0, name.length() - 6);
        }
        name = name.toLowerCase();
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return name;
        }
    }

    public List<String[]> parseDDArgument(String ddFiles, boolean added) {
        StringTokenizer tok = new StringTokenizer(ddFiles, File.pathSeparator);
        ArrayList<String[]> ddEntries = new ArrayList<String[]>();
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            if (!tok.hasMoreTokens()) continue;
            String path = tok.nextToken();
            try {
                name = URLDecoder.decode(name, "UTF-8");
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            ddEntries.add(new String[]{name, path});
            if (added) {
                this.addDDFile(name, path);
                continue;
            }
            this.removeDDFile(name);
        }
        return ddEntries;
    }

    public void addDDFile(String name, String path) {
        this.ddPaths.put(name, path);
        this.removeFromCache(name);
    }

    public void removeDDFile(String name) {
        this.ddPaths.remove(name);
        this.removeFromCache(name);
    }

    private void removeFromCache(String ddName) {
        if (deploymentDescs.size() > 0) {
            deploymentDescs.remove(ddName);
        }
        if (BindingResourceProcessor.getBindings().size() > 0) {
            Iterator<QName> it = BindingResourceProcessor.getBindings().keySet().iterator();
            while (it.hasNext()) {
                QName q = it.next();
                if (!ddName.equals(this.normalizePropertyFileName(q.getNamespaceURI()))) continue;
                it.remove();
            }
        }
    }
}

