/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import java.util.List;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.ArrayLiteral;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class ArrayLiteralTemplate
extends JavaScriptTemplate {
    public void genExpression(ArrayLiteral expr, Context ctx, TabbedWriter out) {
        this.genExpr(expr, ctx, out, null);
    }

    public void genTypeBasedExpression(ArrayLiteral expr, Context ctx, TabbedWriter out, Type arg) {
        this.genExpr(expr, ctx, out, arg);
    }

    private void genExpr(ArrayLiteral expr, Context ctx, TabbedWriter out, Type targetType) {
        Type elementType = null;
        out.print("[");
        if (targetType == null) {
            targetType = (Type)ctx.get((Object)("etType_for_array_conversion_" + expr));
        }
        if (targetType != null) {
            List entries = expr.getEntries();
            elementType = ((ArrayType)targetType).getElementType();
            Type baseType = this.getBaseType(targetType);
            if (baseType instanceof Delegate) {
                elementType = baseType;
            }
            boolean firstElement = true;
            for (Expression element : entries) {
                String functionSig;
                if (firstElement) {
                    firstElement = false;
                } else {
                    out.print(", ");
                }
                if (elementType instanceof Delegate) {
                    functionSig = ((Function)CommonUtilities.getMember((Expression)element)).getSignature();
                    ctx.put((Object)("Delegate_signature_for_function_" + functionSig), (Object)elementType);
                }
                ctx.invoke("genExpression", (EObject)IRUtils.makeExprCompatibleToType((Expression)element, (Type)elementType), new Object[]{ctx, out});
                if (!(elementType instanceof Delegate)) continue;
                functionSig = ((Function)CommonUtilities.getMember((Expression)element)).getSignature();
                ctx.remove((Object)("Delegate_signature_for_function_" + functionSig));
            }
        } else {
            ctx.foreach(expr.getEntries(), ',', "genExpression", new Object[]{ctx, out});
        }
        out.print("].setType(\"[");
        if (elementType == null) {
            elementType = ((ArrayType)expr.getType()).getElementType();
        }
        ctx.put((Object)"isaSignature", (Object)"true");
        ctx.invoke("genSignature", elementType, new Object[]{ctx, out});
        ctx.remove((Object)"isaSignature");
        out.print("\")");
    }

    private Type getBaseType(Type type) {
        if (type instanceof ArrayType) {
            return this.getBaseType(((ArrayType)type).getElementType());
        }
        return type;
    }
}

