/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.gen.javascript.templates.TypeTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.ArrayAccess;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class ArrayAccessTemplate
extends JavaScriptTemplate {
    public void genAssignment(ArrayAccess expr, Context ctx, TabbedWriter out, Expression arg1, String arg2) {
        Expression array = expr.getArray();
        Expression index = expr.getIndex();
        boolean arrayIsAny = TypeUtils.getTypeKind((Type)array.getType()) == 1;
        out.print("egl.setElement(");
        if (arrayIsAny) {
            out.print("egl.unboxAny(");
        }
        if (array.isNullable()) {
            out.print("egl.checkNull(");
            ctx.invoke("genCheckNullArgs", (EObject)expr, new Object[]{ctx, out});
            out.print(")");
        } else {
            ctx.invoke("genExpression", (EObject)array, new Object[]{ctx, out});
        }
        if (arrayIsAny) {
            out.print(")");
        }
        out.print(", ");
        ctx.invoke("genExpression", (EObject)index, new Object[]{ctx, out});
        out.print(" - 1, ");
        if (TypeUtils.getTypeKind((Type)expr.getType()) != 1 && TypeUtils.getTypeKind((Type)expr.getType()) != 30 && (TypeUtils.isReferenceType((Type)expr.getType()) || ctx.mapsToPrimitiveType(expr.getType()))) {
            out.print("egl.unboxAny(");
            ctx.invoke("genExpression", (EObject)arg1, new Object[]{ctx, out});
            out.print(")");
        } else {
            TypeTemplate.assignmentSource((Expression)expr, arg1, ctx, out);
        }
        out.print(")");
    }

    public void genCheckNullArgs(ArrayAccess expr, Context ctx, TabbedWriter out) {
        ctx.invoke("genExpression", (EObject)expr.getArray(), new Object[]{ctx, out});
    }

    public void genExpression(ArrayAccess expr, Context ctx, TabbedWriter out) {
        Field field = null;
        if (expr.getArray() instanceof Name && ((Name)expr.getArray()).getNamedElement() instanceof Field) {
            field = (Field)((Name)expr.getArray()).getNamedElement();
        }
        if (field != null && field.getContainer() != null && field.getContainer() instanceof Type) {
            ctx.invoke("genContainerBasedArrayAccess", (Type)field.getContainer(), new Object[]{ctx, out, expr, field});
        } else {
            this.genArrayAccess(expr, ctx, out);
        }
    }

    public void genArrayAccess(ArrayAccess expr, Context ctx, TabbedWriter out) {
        boolean arrayIsAny;
        Expression array = expr.getArray();
        Expression index = expr.getIndex();
        boolean nullableElements = array.getType() instanceof ArrayType && ((ArrayType)array.getType()).elementsNullable();
        boolean bl = arrayIsAny = TypeUtils.getTypeKind((Type)array.getType()) == 1;
        if (nullableElements) {
            out.print("egl.nullableGetElement(");
            ctx.invoke("genExpression", (EObject)array, new Object[]{ctx, out});
            out.print(", ");
            ctx.invoke("genExpression", (EObject)index, new Object[]{ctx, out});
            out.print(")");
        } else {
            out.print("egl.getElement(");
            if (arrayIsAny) {
                out.print("egl.unboxAny(");
            }
            if (array.isNullable()) {
                out.print("egl.checkNull(");
                ctx.invoke("genCheckNullArgs", (EObject)expr, new Object[]{ctx, out});
                out.print(")");
            } else {
                ctx.invoke("genExpression", (EObject)array, new Object[]{ctx, out});
            }
            if (arrayIsAny) {
                out.print(")");
            }
            out.print(", ");
            ctx.invoke("genExpression", (EObject)index, new Object[]{ctx, out});
            out.print(" - 1)");
        }
    }
}

