/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.java.jtopen.access;

import eglx.jtopen.IBMiConnection;
import eglx.lang.StringLib;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.edt.java.jtopen.access.AS400DateTimeUtil;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;

public class AS400Date
extends com.ibm.as400.access.AS400Date {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat sdf;

    public AS400Date(TimeZone tz) {
        super(tz);
    }

    public AS400Date(Integer ibmiFormat, String seperator, String timeZoneID, IBMiConnection conn) {
        this(AS400DateTimeUtil.getIBMiTimezone(timeZoneID, conn));
        if (ibmiFormat == null) {
            ibmiFormat = conn.getDateFormat();
        }
        seperator = AS400DateTimeUtil.getConnSeparator(seperator, conn);
        if (ibmiFormat != null && seperator != null && seperator.isEmpty()) {
            this.setFormat(ibmiFormat);
        } else if (ibmiFormat != null) {
            Character seperatorChar = seperator == null ? null : Character.valueOf(seperator.charAt(0));
            this.setFormat(ibmiFormat, seperatorChar);
        }
    }

    public byte[] toBytes(Object object) {
        if (object instanceof Calendar) {
            object = this.toSqlDate((Calendar)object);
        }
        return super.toBytes(object);
    }

    public int toBytes(Object object, byte[] bytes) {
        if (object instanceof Calendar) {
            object = this.toSqlDate((Calendar)object);
        }
        return super.toBytes(object, bytes);
    }

    public int toBytes(Object object, byte[] bytes, int offset) {
        if (object instanceof Calendar) {
            object = this.toSqlDate((Calendar)object);
        }
        return super.toBytes(object, bytes, offset);
    }

    private Object toSqlDate(Calendar cal) {
        java.sql.Date returnVal = null;
        try {
            returnVal = new java.sql.Date(this.ibmiSimpleDateFormat().parse(StringLib.format((Calendar)cal, (String)"MM/dd/yyyy")).getTime());
        }
        catch (ParseException parseException) {}
        return returnVal;
    }

    public Object toObject(byte[] arg0) {
        Object obj = super.toObject(arg0);
        return this.convert(obj);
    }

    public Object toObject(byte[] arg0, int arg1) {
        Object obj = super.toObject(arg0, arg1);
        return this.convert(obj);
    }

    private Object convert(Object obj) {
        if (obj instanceof Calendar) {
            return EDate.asDate((Calendar)((Calendar)obj));
        }
        if (obj instanceof java.sql.Date) {
            return EDate.asDate((String)this.ibmiSimpleDateFormat().format((java.sql.Date)obj));
        }
        if (obj instanceof Date) {
            return EDate.asDate((String)this.ibmiSimpleDateFormat().format((Date)obj));
        }
        return obj;
    }

    private SimpleDateFormat ibmiSimpleDateFormat() {
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat("MM/dd/yyyy");
            this.sdf.setTimeZone(this.getTimeZone());
        }
        return this.sdf;
    }
}

