/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.services.servlet.proxy;

import eglx.http.Request;
import java.util.List;
import java.util.Map;

public class ProxyUtilities {
    private static final String EGL_DEDICATED_CALL = "EGLDEDICATED";
    public static final String EGL_SOAP_CALL = "EGLSOAP";
    public static final String EGL_REST_CALL = "EGLREST";
    public static final String HTTP10STATUS = "HTTP/1.0";

    private ProxyUtilities() {
    }

    public static boolean isEGLDedicatedCall(Request innerRequest) {
        return innerRequest.headers != null && innerRequest.headers.containsKey(EGL_DEDICATED_CALL);
    }

    public static String convert(Map<?, ?> map, String EOL) {
        StringBuilder buffer = new StringBuilder();
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                boolean nullKey = entry.getKey() == null || entry.getKey().toString() == null;
                boolean addEOL = true;
                if (!nullKey) {
                    buffer.append(entry.getKey().toString());
                    buffer.append(':');
                }
                if (entry.getValue() instanceof Map) {
                    buffer.append('(');
                    buffer.append(ProxyUtilities.convert((Map)entry.getValue(), EOL));
                    buffer.append(')');
                } else if (entry.getValue() instanceof List) {
                    boolean addComma = false;
                    for (Object value : (List)entry.getValue()) {
                        if (addComma) {
                            buffer.append(',');
                        }
                        addComma = true;
                        if (value != null && value.toString().indexOf(HTTP10STATUS) > -1) {
                            buffer.insert(0, EOL);
                            buffer.insert(0, value.toString());
                            addEOL = false;
                            continue;
                        }
                        buffer.append(value.toString());
                    }
                } else if (entry.getValue() != null) {
                    buffer.append(entry.getValue().toString());
                }
                if (!addEOL) continue;
                buffer.append(EOL);
            }
        }
        buffer.append(EOL);
        return buffer.toString();
    }

    public static boolean isSoapCall(Request innerRequest) {
        return innerRequest.headers != null && innerRequest.headers.containsKey(EGL_SOAP_CALL);
    }
}

