/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapterExtension;
import org.eclipse.edt.debug.core.IEGLValue;
import org.eclipse.edt.debug.core.IEGLVariable;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugElement;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugTarget;
import org.eclipse.edt.debug.javascript.internal.model.RUIStackFrame;
import org.eclipse.edt.debug.javascript.internal.model.RUIValue;

public class RUIVariable
extends RUIDebugElement
implements IEGLVariable {
    private String fName;
    private String fJSName;
    private String fGetterName;
    private String fSetterName;
    private RUIStackFrame fFrame;
    private String fIndex;
    private RUIValue fValue;
    private String fType;
    private String fQualifiedName;
    private String fOldValueString;
    private boolean fHasChildren;
    private RUIVariable fParentVariable;

    public RUIVariable(RUIStackFrame frame, RUIVariable parent, String name, String jsName, String getterName, String setterName, String qualifiedName, String index, String type, boolean hasChildren) {
        super((RUIDebugTarget)frame.getDebugTarget());
        this.initialize(frame, parent, name, jsName, getterName.trim(), setterName.trim(), qualifiedName, index, type, hasChildren);
    }

    public void initialize(RUIStackFrame frame, RUIVariable parent, RUIVariable other) {
        this.fOldValueString = this.getCurrentValueString();
        this.initialize(frame, parent, other.fName, other.fJSName, other.fGetterName, other.fSetterName, other.fQualifiedName, other.fIndex, other.fType, other.fHasChildren);
    }

    private void initialize(RUIStackFrame frame, RUIVariable parent, String name, String jsName, String getterName, String setterName, String qualifiedName, String index, String type, boolean hasChildren) {
        this.fFrame = frame;
        this.fName = name;
        this.fJSName = jsName == null ? "" : jsName.trim();
        this.fGetterName = getterName;
        this.fSetterName = setterName;
        this.fQualifiedName = qualifiedName;
        this.fIndex = index;
        this.fType = type;
        this.fHasChildren = hasChildren;
        this.fValue = null;
        this.fParentVariable = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getValue() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        synchronized (iDebugTarget) {
            if (this.getCurrValue().getValueString() == null) {
                return ((RUIDebugTarget)this.getDebugTarget()).getVariableValue(this);
            }
            return this.getCurrValue();
        }
    }

    public String getName() {
        return this.fName;
    }

    public String getReferenceTypeName() {
        return this.fType;
    }

    public RUIVariable getParent() {
        return this.fParentVariable;
    }

    public String getJSName() {
        return this.fJSName;
    }

    public String getGetterName() {
        return this.fGetterName;
    }

    public String getSetterName() {
        return this.fSetterName;
    }

    public boolean hasValueChanged() {
        return ((RUIValue)this.getValue()).hasChanged();
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    public RUIStackFrame getStackFrame() {
        return this.fFrame;
    }

    public String getIndex() {
        return this.fIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEGLVariable[] getVariables() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        synchronized (iDebugTarget) {
            return ((RUIDebugTarget)this.getDebugTarget()).getVariables(this);
        }
    }

    public RUIValue getCurrValue() {
        if (this.fValue == null) {
            this.fValue = new RUIValue((RUIDebugTarget)this.getDebugTarget(), this, this.fHasChildren, this.fOldValueString);
        }
        return this.fValue;
    }

    public void setType(String type) {
        this.fType = type;
    }

    public String getLabel(boolean qualified) {
        String label = null;
        StringBuilder buf = new StringBuilder(20);
        try {
            String type;
            if (qualified && (type = this.getReferenceTypeName()) != null && (type = type.trim()).length() != 0) {
                buf.append(type);
                buf.append(" ");
            }
            buf.append(this.getName());
            String value = this.getValue().getValueString();
            if (value != null) {
                buf.append(" = ");
                buf.append(value);
            }
            label = buf.toString();
        }
        catch (DebugException debugException) {}
        return label;
    }

    protected String getCurrentValueString() {
        if (this.fValue != null) {
            return this.fValue.getValueString();
        }
        return null;
    }

    public String getQualifiedName() {
        return this.fQualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.fQualifiedName = qualifiedName;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == RUIVariable.class || adapter == IVariable.class || adapter == IEGLVariable.class) {
            return this;
        }
        if (adapter == IWatchExpressionFactoryAdapter.class) {
            return new IWatchExpressionFactoryAdapterExtension(){

                public String createWatchExpression(IVariable variable) throws CoreException {
                    return variable.getName();
                }

                public boolean canCreateWatchExpression(IVariable variable) {
                    return false;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public IEGLValue getEGLValue() throws DebugException {
        return (IEGLValue)this.getValue();
    }

    public boolean isNull() {
        try {
            return "null".equals(this.getValue().getValueString());
        }
        catch (DebugException debugException) {
            return true;
        }
    }

    public String getWatchExpressionString() {
        return "";
    }
}

