/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static char[] LINE_SEPARATOR_CHARS = LINE_SEPARATOR.toCharArray();
    public static final char[] SUFFIX_class = ".class".toCharArray();
    public static final char[] SUFFIX_CLASS = ".CLASS".toCharArray();
    public static final char[] SUFFIX_java = ".java".toCharArray();
    public static final char[] SUFFIX_JAVA = ".JAVA".toCharArray();
    public static final char[] SUFFIX_jar = ".jar".toCharArray();
    public static final char[] SUFFIX_JAR = ".JAR".toCharArray();
    public static final char[] SUFFIX_zip = ".zip".toCharArray();
    public static final char[] SUFFIX_ZIP = ".ZIP".toCharArray();
    private static final int DEFAULT_READING_SIZE = 8192;
    public static final String EGLPATH_FILENAME = ".eglPath";
    public static final IEGLPathEntry[] INVALID_EGLPATH = new IEGLPathEntry[0];

    public static char[] bytesToChar(byte[] bytes, String encoding) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(bytes), bytes.length, encoding);
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block7: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        char[] cArray;
        block7: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = CharOperation.NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    public static byte[] getZipEntryByteContent(ZipEntry ze, ZipFile zip) throws IOException {
        byte[] byArray;
        block7: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(zip.getInputStream(ze));
                byArray = Util.getInputStreamAsByteArray(stream, (int)ze.getSize());
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static final boolean isArchiveFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAR.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_jar[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAR[suffixIndex]) {
                suffixLength = SUFFIX_ZIP.length;
                if (nameLength < suffixLength) {
                    return false;
                }
                int j = 0;
                while (j < suffixLength) {
                    c = name.charAt(nameLength - j - 1);
                    if (c != SUFFIX_zip[suffixIndex = suffixLength - j - 1] && c != SUFFIX_ZIP[suffixIndex]) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isClassFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_CLASS.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_class[suffixIndex = suffixLength - i - 1] && c != SUFFIX_CLASS[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length;
        if (nameLength < (suffixLength = SUFFIX_CLASS.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name[offset + i];
            if (c != SUFFIX_class[i] && c != SUFFIX_CLASS[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isJavaFileName(String name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length();
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            int suffixIndex;
            char c = name.charAt(nameLength - i - 1);
            if (c != SUFFIX_java[suffixIndex = suffixLength - i - 1] && c != SUFFIX_JAVA[suffixIndex]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean isJavaFileName(char[] name) {
        int suffixLength;
        int nameLength = name == null ? 0 : name.length;
        if (nameLength < (suffixLength = SUFFIX_JAVA.length)) {
            return false;
        }
        int i = 0;
        int offset = nameLength - suffixLength;
        while (i < suffixLength) {
            char c = name[offset + i];
            if (c != SUFFIX_java[i] && c != SUFFIX_JAVA[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBinaryProject(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File tempFile = fileArray[n2];
            if (".readonly".equalsIgnoreCase(tempFile.getName())) {
                return true;
            }
            ++n2;
        }
        return Util.isValidEGLFileAndNoOutputEntry(file);
    }

    public static boolean isBinaryProject(IProject proj) {
        return Util.isBinaryProject(new File(proj.getLocation().toString()));
    }

    public static String[] getEGLSourceFolders(File file) {
        ArrayList<String> eglSourceFoldersList = new ArrayList<String>();
        Element cpElement = Util.getEGLPathRoot(file);
        if (cpElement == null) {
            return null;
        }
        try {
            if (!cpElement.getNodeName().equalsIgnoreCase("eglpath")) {
                throw new IOException(EGLModelResources.fileBadFormat);
            }
            NodeList list = cpElement.getElementsByTagName("eglpathentry");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                String pathAttr;
                String kindAttr;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && ((Element)node).hasAttribute("kind") && "src".equalsIgnoreCase(kindAttr = ((Element)node).getAttribute("kind")) && ((Element)node).hasAttribute("path") && !(pathAttr = ((Element)node).getAttribute("path")).startsWith("/")) {
                    eglSourceFoldersList.add(pathAttr);
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return eglSourceFoldersList.toArray(new String[eglSourceFoldersList.size()]);
    }

    private static Element getEGLPathRoot(File file) {
        Element cpElement;
        String xmlPath = String.valueOf(file.getAbsolutePath()) + "/" + EGLPATH_FILENAME;
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(xmlPath));
            byte[] bytes = Util.getInputStreamAsByteArray(inputStream, -1);
            String contents = new String(bytes, "UTF-8");
            StringReader reader = new StringReader(contents);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(EGLModelResources.fileBadFormat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(EGLModelResources.fileBadFormat);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return cpElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidEGLFileAndNoOutputEntry(File file) {
        Element cpElement = Util.getEGLPathRoot(file);
        if (cpElement == null) {
            return false;
        }
        try {
            if (!cpElement.getNodeName().equalsIgnoreCase("eglpath")) {
                throw new IOException(EGLModelResources.fileBadFormat);
            }
            NodeList list = cpElement.getElementsByTagName("eglpathentry");
            int length = list.getLength();
            int i = 0;
            while (true) {
                String kindAttr;
                if (i >= length) {
                    return true;
                }
                Node node = list.item(i);
                if (node.getNodeType() == 1 && ((Element)node).hasAttribute("kind") && "output".equalsIgnoreCase(kindAttr = ((Element)node).getAttribute("kind"))) {
                    return false;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

