/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IImportDeclaration;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;

public class EGLModelUtil {
    public static IPart findPart(IEGLProject jproject, String fullyQualifiedName) throws EGLModelException {
        IPart type = jproject.findPart(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = EGLModelUtil.findPart(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getEGLProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    private static IPart findPart(IPackageFragmentRoot root, String fullyQualifiedName) throws EGLModelException {
        IEGLElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            IPart type;
            IPackageFragment pack;
            IEGLElement element = children[i];
            if (element.getElementType() == 4 && fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) && (type = EGLModelUtil.findPart(pack, fullyQualifiedName)) != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IPart findPart(IPackageFragment pack, String fullyQualifiedName) throws EGLModelException {
        IEGLFile[] cus = pack.getEGLFiles();
        int i = 0;
        while (i < cus.length) {
            IEGLFile unit = cus[i];
            IPart type = EGLModelUtil.findPart(unit, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static IPart findUnqualifiedPart(IPackageFragment pack, String name) throws EGLModelException {
        IEGLFile[] cus = pack.getEGLFiles();
        int i = 0;
        while (i < cus.length) {
            IEGLFile unit = cus[i];
            IPart type = EGLModelUtil.findUnqualifiedPart(unit, name);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IPart findPart(IEGLFile cu, String fullyQualifiedName) throws EGLModelException {
        IPart[] types = cu.getAllParts();
        int i = 0;
        while (i < types.length) {
            IPart type = types[i];
            if (EGLModelUtil.getFullyQualifiedName(type).equals(fullyQualifiedName)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IPart findUnqualifiedPart(IEGLFile cu, String name) throws EGLModelException {
        IPart[] types = cu.getAllParts();
        int i = 0;
        while (i < types.length) {
            IPart type = types[i];
            if (type.getElementName().equals(name)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static IPart findPart(IEGLProject jproject, String pack, String typeQualifiedName) throws EGLModelException {
        return jproject.findPart(pack, typeQualifiedName);
    }

    public static IEGLElement findPartContainer(IEGLProject jproject, String typeContainerName) throws EGLModelException {
        IPackageFragment result = null;
        Path path = new Path(typeContainerName.replace('.', '/'));
        result = jproject.findPackageFragment((IPath)path);
        if (!(result instanceof IPackageFragment)) {
            result = null;
        }
        return result;
    }

    public static IPart findPartInEGLFile(IEGLFile cu, String typeQualifiedName) throws EGLModelException {
        IPart[] types = cu.getAllParts();
        int i = 0;
        while (i < types.length) {
            String currName = types[i].getElementName();
            if (typeQualifiedName.equals(currName)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static IMember findMemberInEGLFile(IEGLFile cu, IMember member) throws EGLModelException {
        IEGLElement[] elements = cu.findElements(member);
        if (elements != null && elements.length > 0) {
            return (IMember)elements[0];
        }
        return null;
    }

    public static IEGLElement findInEGLFile(IEGLFile cu, IEGLElement element) throws EGLModelException {
        IEGLElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getFullyQualifiedName(IPart type) {
        return type.getFullyQualifiedName('.');
    }

    public static String getPartContainerName(IPart type) {
        IPart outerType = type.getDeclaringPart();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws EGLModelException {
        return true;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IEGLElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IEGLElement findParentOfKind(IEGLElement element, int kind) {
        if (element != null && element.getParent() != null) {
            return element.getParent().getAncestor(kind);
        }
        return null;
    }

    public static boolean isOnBuildPath(IEGLProject jproject, IEGLElement element) throws EGLModelException {
        return jproject.isOnEGLPath(element);
    }

    public static boolean isOnEGLPath(IEGLElement element) {
        IEGLProject project = element.getEGLProject();
        if (!project.exists()) {
            return false;
        }
        return project.isOnEGLPath(element);
    }

    public static boolean isEditable(IEGLFile cu) {
        IResource resource;
        if (cu.isWorkingCopy()) {
            cu = (IEGLFile)cu.getOriginalElement();
        }
        return (resource = cu.getResource()).exists() && !resource.isReadOnly();
    }

    public static IImportDeclaration findImport(IEGLFile cu, String simpleName) throws EGLModelException {
        IImportDeclaration[] existing = cu.getImports();
        int i = 0;
        while (i < existing.length) {
            int dotPos;
            String curr = existing[i].getElementName();
            if (curr.endsWith(simpleName) && ((dotPos = curr.length() - simpleName.length() - 1) == -1 || dotPos > 0 && curr.charAt(dotPos) == '.')) {
                return existing[i];
            }
            ++i;
        }
        return null;
    }

    public static IEGLFile toOriginal(IEGLFile cu) {
        if (cu != null && cu.isWorkingCopy()) {
            return (IEGLFile)cu.getOriginal(cu);
        }
        return cu;
    }

    public static IEGLFile toWorkingCopy(IEGLFile cu) {
        return cu;
    }

    public static boolean filterNotPresentException(CoreException exception) {
        if (!(exception instanceof EGLModelException)) {
            return true;
        }
        EGLModelException je = (EGLModelException)exception;
        if (!je.isDoesNotExist()) {
            return true;
        }
        IEGLElement[] elements = je.getEGLModelStatus().getElements();
        int i = 0;
        while (i < elements.length) {
            IEGLElement element = elements[i];
            IEGLFile unit = (IEGLFile)element.getAncestor(6);
            if (unit == null) {
                return true;
            }
            if (!unit.isWorkingCopy()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

