/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.MemberElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceRange;
import org.eclipse.edt.ide.core.internal.model.SourceRefElement;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.Signature;

abstract class Member
extends SourceRefElement
implements IMember {
    protected Member(int type, IEGLElement parent, String name) {
        super(type, parent, name);
    }

    protected boolean areSimilarFunctions(String name1, String[] params1, String name2, String[] params2, String[] simpleNames1) {
        int params1Length;
        if (name1.equalsIgnoreCase(name2) && (params1Length = params1.length) == params2.length) {
            int i = 0;
            while (i < params1Length) {
                String simpleName2;
                String simpleName1 = simpleNames1 == null ? Signature.getSimpleName(Signature.toString(params1[i])) : simpleNames1[i];
                if (!simpleName1.equals(simpleName2 = Signature.getSimpleName(Signature.toString(params2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected IFunction[] findFunctions(IFunction function, IFunction[] functions) {
        String elementName = function.getElementName();
        String[] parameters = function.getParameterTypes();
        int paramLength = parameters.length;
        String[] simpleNames = new String[paramLength];
        int i = 0;
        while (i < paramLength) {
            simpleNames[i] = Signature.getSimpleName(Signature.toString(parameters[i]));
            ++i;
        }
        ArrayList<IFunction> list = new ArrayList<IFunction>();
        int i2 = 0;
        int length = functions.length;
        while (i2 < length) {
            IFunction existingFunction = functions[i2];
            if (this.areSimilarFunctions(elementName, parameters, existingFunction.getElementName(), existingFunction.getParameterTypes(), simpleNames)) {
                list.add(existingFunction);
            }
            ++i2;
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        IFunction[] result = new IFunction[size];
        list.toArray(result);
        return result;
    }

    @Override
    public IPart getDeclaringPart() {
        EGLElement parent = (EGLElement)this.getParent();
        if (parent.fLEType == 8) {
            return (IPart)((Object)parent);
        }
        return null;
    }

    @Override
    public int getFlags() throws EGLModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '[';
    }

    @Override
    public ISourceRange getNameRange() throws EGLModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return new SourceRange(info.getNameSourceStart(), info.getNameSourceEnd() - info.getNameSourceStart() + 1);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.isBinary();
    }

    @Override
    public String readableName() {
        IPart declaringType = this.getDeclaringPart();
        if (declaringType != null) {
            String declaringName = ((EGLElement)((Object)this.getDeclaringPart())).readableName();
            StringBuffer buffer = new StringBuffer(declaringName);
            buffer.append('.');
            buffer.append(this.getElementName());
            return buffer.toString();
        }
        return super.readableName();
    }

    protected void updateNameRange(int nameStart, int nameEnd) {
        try {
            MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
            info.setNameSourceStart(nameStart);
            info.setNameSourceEnd(nameEnd);
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
    }

    @Override
    public IClassFile getClassFile() {
        return ((EGLElement)this.getParent()).getClassFile();
    }
}

