/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.model.IEGLElement;

class EGLElementInfo {
    protected IEGLElement[] fChildren = fgEmptyChildren;
    protected static IEGLElement[] fgEmptyChildren = new IEGLElement[0];
    protected boolean fIsStructureKnown = false;
    static Object[] NO_NON_EGL_RESOURCES = new Object[0];

    protected EGLElementInfo() {
    }

    public void addChild(IEGLElement child) {
        if (this.fChildren == fgEmptyChildren) {
            this.setChildren(new IEGLElement[]{child});
        } else if (!this.includesChild(child)) {
            this.setChildren(this.growAndAddToArray(this.fChildren, child));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public IEGLElement[] getChildren() {
        return this.fChildren;
    }

    protected IEGLElement[] growAndAddToArray(IEGLElement[] array, IEGLElement addition) {
        IEGLElement[] old = array;
        array = new IEGLElement[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected boolean includesChild(IEGLElement child) {
        int i = 0;
        while (i < this.fChildren.length) {
            if (this.fChildren[i].equals(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isStructureKnown() {
        return this.fIsStructureKnown;
    }

    protected IEGLElement[] removeAndShrinkArray(IEGLElement[] array, IEGLElement deletion) {
        IEGLElement[] old = array;
        array = new IEGLElement[old.length - 1];
        int j = 0;
        int i = 0;
        while (i < old.length) {
            if (old[i].equals(deletion)) {
                System.arraycopy(old, i + 1, array, j, old.length - (i + 1));
                return array;
            }
            array[j] = old[i];
            ++j;
            ++i;
        }
        return array;
    }

    public void removeChild(IEGLElement child) {
        if (this.includesChild(child)) {
            this.setChildren(this.removeAndShrinkArray(this.fChildren, child));
        }
    }

    public void setChildren(IEGLElement[] children) {
        this.fChildren = children;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.fIsStructureKnown = newIsStructureKnown;
    }
}

