/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.partinfo.EGLBinaryProjectOrigin;
import org.eclipse.edt.ide.core.internal.partinfo.EGLFileOrigin;
import org.eclipse.edt.ide.core.internal.partinfo.EGLSourcelessProjectOrigin;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class AbstractProjectInfo {
    private IProject project;
    private ResourceInfo rootResourceInfo;

    public AbstractProjectInfo(IProject project) {
        this.project = project;
        this.initialize();
    }

    private void initialize() {
        this.initializeProjectInfo();
    }

    private void initializeProjectInfo() {
        this.rootResourceInfo = new ResourceInfo();
        IContainer[] sourceLocations = this.getSourceLocations(this.project);
        int i = 0;
        while (i < sourceLocations.length) {
            this.initializeEGLPackageHelper(sourceLocations[i], this.rootResourceInfo);
            ++i;
        }
    }

    protected abstract IContainer[] getSourceLocations(IProject var1);

    private void initializeEGLPackageHelper(IContainer parent, final ResourceInfo parentMap) {
        final ArrayList subFolders = new ArrayList();
        try {
            IResource[] resources = parent.members();
            int i = 0;
            while (i < resources.length) {
                resources[i].accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        switch (resource.getType()) {
                            case 1: {
                                if (Util.isEGLFileName(resource.getName())) {
                                    AbstractProjectInfo.this.initializeEGLFileHelper((IFile)resource, parentMap);
                                }
                                return false;
                            }
                            case 2: {
                                subFolders.add(resource);
                                return false;
                            }
                        }
                        return false;
                    }
                }, 0, false);
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException("Error initializing ProjectInfo", (Throwable)e);
        }
        for (IFolder resource : subFolders) {
            ResourceInfo info = parentMap.addPackage(NameUtile.getAsName((String)resource.getName()));
            this.initializeEGLPackageHelper((IContainer)resource, info);
        }
    }

    private void initializeEGLFileHelper(IFile file, ResourceInfo parentResourceInfo) {
        IFileInfo fileInfo = this.getCachedFileInfo(this.project, file.getProjectRelativePath());
        if (fileInfo != null) {
            Set partNames = fileInfo.getPartNames();
            for (String partName : partNames) {
                PackageAndPartName ppName = new PackageAndPartName(fileInfo.getCaseSensitivePackageName(), fileInfo.getCaseSensitivePartName(partName));
                parentResourceInfo.addPart(partName, fileInfo.getPartType(partName), file, ppName);
            }
        }
    }

    protected abstract IFileInfo getCachedFileInfo(IProject var1, IPath var2);

    public IProject getProject() {
        return this.project;
    }

    public boolean hasPackage(String packageName) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isReadOnly()) {
            ResourceInfo info;
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isBinary() && (info = this.getPackageInfo(packageName)) != null) {
                return true;
            }
            IFolder packageLocation = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getOutputLocation().getFolder((IPath)new Path(IRFileNameUtility.toIRFileName((String)packageName).replace('.', '/')));
            return packageLocation.exists();
        }
        String[] pkgSegments = org.eclipse.edt.ide.core.internal.utils.Util.qualifiedNameToStringArray(packageName);
        ResourceInfo info = this.rootResourceInfo;
        int i = 0;
        while (i < pkgSegments.length) {
            if ((info = info.getPackage(pkgSegments[i])) == null) break;
            ++i;
        }
        return info != null;
    }

    public int hasPart(String packageName, String partName) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isReadOnly()) {
            int value;
            ResourceInfo info;
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isBinary() && (info = this.getPackageInfo(packageName)) != null && (value = info.getPartType(partName)) != 1) {
                return value;
            }
            IFolder packageLocation = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getOutputLocation().getFolder((IPath)new Path(IRFileNameUtility.toIRFileName((String)packageName).replace('.', '/')));
            if (packageLocation.exists() && packageLocation.findMember(IRFileNameUtility.toIRFileName((String)(String.valueOf(partName) + ".eglxml"))) != null) {
                return 28;
            }
            return 1;
        }
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            return info.getPartType(partName);
        }
        return 1;
    }

    private ResourceInfo getPackageInfo(String packageName) {
        String[] pkgSegments = org.eclipse.edt.ide.core.internal.utils.Util.qualifiedNameToStringArray(packageName);
        ResourceInfo info = this.rootResourceInfo;
        int i = 0;
        while (i < pkgSegments.length) {
            if ((info = info.getPackage(pkgSegments[i])) == null) break;
            ++i;
        }
        return info;
    }

    public IPartOrigin getPartOrigin(String packageName, String partName) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isReadOnly()) {
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isBinary()) {
                ResourceInfo info = this.getPackageInfo(packageName);
                if (info != null) {
                    IFile file = null;
                    file = info.getFile(partName);
                    return new EGLBinaryProjectOrigin(file);
                }
                return null;
            }
            return new EGLSourcelessProjectOrigin();
        }
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            return new EGLFileOrigin(info.getFile(partName));
        }
        return null;
    }

    public String toString() {
        return this.project.getName();
    }

    public void packageRemoved(String packageName) {
        String parentPackage = packageName;
        int lastDot = packageName.lastIndexOf(46);
        parentPackage = lastDot != -1 ? packageName.substring(0, lastDot) : "";
        ResourceInfo info = this.getPackageInfo(parentPackage);
        info.removePackage(lastDot == -1 ? packageName : packageName.substring(lastDot + 1));
    }

    public void packageAdded(String packageName) {
        String parentPackage = packageName;
        int lastDot = packageName.lastIndexOf(46);
        parentPackage = lastDot != -1 ? packageName.substring(0, lastDot) : "";
        ResourceInfo info = this.getPackageInfo(parentPackage);
        info.addPackage(lastDot == -1 ? packageName : packageName.substring(lastDot + 1));
    }

    public void partAdded(String packageName, String partName, int partType, IFile file, PackageAndPartName ppName) {
        ResourceInfo info = this.getPackageInfo(packageName);
        info.addPart(partName, partType, file, ppName);
    }

    public void partRemoved(String packageName, String partName, IFile file) {
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            info.removePart(partName);
        }
    }

    public void clear() {
        this.rootResourceInfo = null;
        this.initialize();
    }

    public PackageAndPartName getPackageAndPartName(String packageName, String partName) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isReadOnly()) {
            PackageAndPartName ppName;
            ResourceInfo info;
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isBinary() && (info = this.getPackageInfo(packageName)) != null && (ppName = info.getPackageAndPartName(partName)) != null) {
                return ppName;
            }
            throw new UnsupportedOperationException();
        }
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            return info.getPackageAndPartName(partName);
        }
        return null;
    }

    public String getCaseSensitivePartName(String packageName, String partName) {
        if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isReadOnly()) {
            String name;
            ResourceInfo info;
            if (ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).isBinary() && (info = this.getPackageInfo(packageName)) != null && (name = info.getCaseSensitivePartName(partName)) != null) {
                return name;
            }
            throw new UnsupportedOperationException();
        }
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            return info.getCaseSensitivePartName(partName);
        }
        return null;
    }

    private class PartEntry {
        private int partType;
        private IFile file;
        private PackageAndPartName ppName;

        public PartEntry(int partType, IFile file, PackageAndPartName ppName) {
            this.partType = partType;
            this.file = file;
            this.ppName = ppName;
        }

        public IFile getFile() {
            return this.file;
        }

        public int getPartType() {
            return this.partType;
        }

        public String getCaseSensitivePartName() {
            return this.ppName.getCaseSensitivePartName();
        }

        public PackageAndPartName getPackageAndPartName() {
            return this.ppName;
        }
    }

    private class ResourceInfo {
        private HashMap<String, ResourceInfo> packages;
        private HashMap<String, PartEntry> parts;

        private ResourceInfo() {
        }

        public ResourceInfo addPackage(String packageName) {
            ResourceInfo pkgInfo;
            if (this.packages == null) {
                this.packages = new HashMap(5);
            }
            if ((pkgInfo = this.packages.get(packageName)) == null) {
                pkgInfo = new ResourceInfo();
                this.packages.put(packageName, pkgInfo);
            }
            return pkgInfo;
        }

        public ResourceInfo getPackage(String packageName) {
            if (this.packages != null) {
                return this.packages.get(packageName);
            }
            return null;
        }

        public void addPart(String partName, int partType, IFile file, PackageAndPartName ppName) {
            if (this.parts == null) {
                this.parts = new HashMap();
            }
            this.parts.put(partName, new PartEntry(partType, file, ppName));
        }

        public String getCaseSensitivePartName(String partName) {
            PartEntry part = this.getPart(partName);
            if (part != null) {
                return part.getCaseSensitivePartName();
            }
            return null;
        }

        public PackageAndPartName getPackageAndPartName(String partName) {
            PartEntry part = this.getPart(partName);
            if (part != null) {
                return part.getPackageAndPartName();
            }
            return null;
        }

        public IFile getFile(String partName) {
            PartEntry part = this.getPart(partName);
            if (part != null) {
                return part.getFile();
            }
            return null;
        }

        public int getPartType(String partName) {
            PartEntry part = this.getPart(partName);
            if (part != null) {
                return part.getPartType();
            }
            return 1;
        }

        private PartEntry getPart(String partName) {
            if (this.parts != null) {
                return this.parts.get(partName);
            }
            return null;
        }

        public void removePackage(String packageName) {
            if (this.packages != null) {
                this.packages.remove(packageName);
            }
        }

        public void removePart(String partName) {
            if (this.parts != null) {
                this.parts.remove(partName);
            }
        }

        public String toString() {
            Set<String> set;
            StringBuffer result = new StringBuffer();
            result.append("Packages: \n");
            if (this.packages == null) {
                result.append("\tNone");
            } else {
                set = this.packages.keySet();
                for (String pkgName : set) {
                    result.append("\t" + pkgName + "\n");
                }
            }
            result.append("\n");
            result.append("Parts: \n");
            if (this.parts == null) {
                result.append("\tNone");
            } else {
                set = this.parts.keySet();
                for (String partName : set) {
                    result.append("\t" + partName + "\n");
                }
            }
            result.append("\n");
            return result.toString();
        }
    }
}

