/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.io;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.utils.ReadWriteMonitor;
import org.eclipse.edt.compiler.internal.io.IOBuffer;
import org.eclipse.edt.ide.core.internal.io.IIOBufferReaderFactory;
import org.eclipse.edt.ide.core.internal.io.IIOBufferWriterFactory;

public class IOBufferPool {
    private static final int MAX_NUMBER_OF_BUFFERS = 10000;
    private ReadWriteMonitor poolMonitor = new ReadWriteMonitor();
    private HashMap bufferMap = new HashMap();
    private HashMap monitorMap = new HashMap();
    private IIOBufferReaderFactory readerFactory;
    private IIOBufferWriterFactory writerFactory;

    public IOBufferPool(IIOBufferReaderFactory readerFactory, IIOBufferWriterFactory writerFactory) {
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
    }

    public Object get(IPath bufferPath, String key) {
        Object value = null;
        this.poolMonitor.enterRead();
        try {
            IOBuffer buffer = this.getBuffer(bufferPath);
            ReadWriteMonitor bufferMonitor = (ReadWriteMonitor)this.monitorMap.get(bufferPath);
            bufferMonitor.enterRead();
            try {
                value = buffer.get(key);
            }
            finally {
                bufferMonitor.exitRead();
            }
        }
        finally {
            this.poolMonitor.exitRead();
        }
        this.requestCleanup();
        return value;
    }

    public void put(IPath bufferPath, String key, Object value) {
        this.poolMonitor.enterRead();
        try {
            IOBuffer buffer = this.getBuffer(bufferPath);
            ReadWriteMonitor bufferMonitor = (ReadWriteMonitor)this.monitorMap.get(bufferPath);
            bufferMonitor.enterWrite();
            try {
                buffer.put(key, value);
            }
            finally {
                bufferMonitor.exitWrite();
            }
        }
        finally {
            this.poolMonitor.exitRead();
        }
        this.requestCleanup();
    }

    public void remove(IPath bufferPath, String key) {
        this.poolMonitor.enterRead();
        try {
            IOBuffer buffer = this.getBuffer(bufferPath);
            ReadWriteMonitor bufferMonitor = (ReadWriteMonitor)this.monitorMap.get(bufferPath);
            bufferMonitor.enterWrite();
            try {
                buffer.remove(key);
            }
            finally {
                bufferMonitor.exitWrite();
            }
        }
        finally {
            this.poolMonitor.exitRead();
        }
        this.requestCleanup();
    }

    public void remove(IPath bufferPath) {
        this.poolMonitor.enterRead();
        try {
            this.removeBuffer(bufferPath);
        }
        finally {
            this.poolMonitor.exitRead();
        }
    }

    public void flush() {
        this.cleanup();
    }

    private synchronized IOBuffer getBuffer(IPath bufferPath) {
        IOBuffer buffer = (IOBuffer)this.bufferMap.get(bufferPath);
        if (buffer == null) {
            buffer = new IOBuffer(this.readerFactory.getReader(bufferPath), this.writerFactory.getWriter(bufferPath));
            this.bufferMap.put(bufferPath, buffer);
            this.monitorMap.put(bufferPath, new ReadWriteMonitor());
        }
        return buffer;
    }

    private synchronized void removeBuffer(IPath bufferPath) {
        IOBuffer buffer = (IOBuffer)this.bufferMap.get(bufferPath);
        if (buffer != null) {
            this.bufferMap.remove(bufferPath);
            this.monitorMap.remove(bufferPath);
        }
    }

    private synchronized void requestCleanup() {
        if (this.bufferMap.size() > 10000) {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            this.poolMonitor.enterWrite();
            for (Object key : this.bufferMap.keySet()) {
                IOBuffer buffer = (IOBuffer)this.bufferMap.get(key);
                buffer.writeCache();
            }
        }
        finally {
            this.clearMembers();
            this.poolMonitor.exitWrite();
        }
    }

    public void clear() {
        this.poolMonitor.enterWrite();
        try {
            this.clearMembers();
        }
        finally {
            this.poolMonitor.exitWrite();
        }
    }

    private void clearMembers() {
        this.bufferMap.clear();
        this.monitorMap.clear();
    }
}

