/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public class Reporter {
    private static Reporter instance = new Reporter();
    public boolean reportRecoveryTrials = false;
    public boolean reportRecovery = false;
    public boolean reportParseProgress = false;

    private Reporter() {
    }

    public static Reporter getInstance() {
        return instance;
    }

    public void shift(ParseNode node, int state) {
        if (!this.reportParseProgress) {
            return;
        }
        if (node.isTerminal()) {
            TerminalNode terminalNode = (TerminalNode)node;
            System.err.println("Shift " + terminalNode.text + " into state: " + state);
        } else if (node.isNonTerminal()) {
            NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
            System.err.println("Shift " + EGLNodeNameUtility.getNonterminalName(nonTerminalNode.nonTerminalType) + " into state: " + state);
        }
    }

    public void reduce(int ruleNumber) {
        if (!this.reportParseProgress) {
            return;
        }
        System.err.println("Reduce using rule: " + ruleNumber);
    }

    public void unexpectedTerminalDistance(int distance) {
        if (!this.reportRecoveryTrials) {
            return;
        }
        System.out.println("Unexpected Terminal: " + distance);
    }

    public void missingTerminalDistance(int terminal, int distance) {
        if (!this.reportRecoveryTrials) {
            return;
        }
        System.out.println("Missing terminal: " + EGLNodeNameUtility.getTerminalName(terminal) + " distance :" + distance);
    }

    public void invalidTerminalDistance(int terminal, int distance) {
        if (!this.reportRecoveryTrials) {
            return;
        }
        System.out.println("Invalid terminal: " + EGLNodeNameUtility.getTerminalName(terminal) + " distance :" + distance);
    }

    public void missingNonTerminalDistance(int nonTerminal, int distance) {
        if (!this.reportRecoveryTrials) {
            return;
        }
        System.out.println("Missing nonTerminal: " + EGLNodeNameUtility.getNonterminalName(nonTerminal));
    }

    public void recoverMissingTerminal(int terminal) {
        if (!this.reportRecovery) {
            return;
        }
        System.out.println("Missing " + EGLNodeNameUtility.getTerminalName(terminal));
    }

    public void recoverInvalidTerminal(String source, int terminal) {
        if (!this.reportRecovery) {
            return;
        }
        System.out.println(String.valueOf('\"') + source + "\" is not a valid " + EGLNodeNameUtility.getTerminalName(terminal));
    }

    public void recoverUnexpectedTerminal(String source) {
        if (!this.reportRecovery) {
            return;
        }
        System.out.println(String.valueOf('\"') + source + "\" is unexpected");
    }

    public void recoverMissingNonTerminal(int nonTerminal) {
        if (!this.reportRecovery) {
            return;
        }
        System.out.println("Missing " + EGLNodeNameUtility.getNonterminalName(nonTerminal));
    }
}

