/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.ParseNode;

public class NonTerminalNode
extends ParseNode {
    public int nonTerminalType;
    public ParseNode[] children;
    public int ruleNumber;

    public NonTerminalNode(int nonterminalType, ParseNode[] children) {
        this.nonTerminalType = nonterminalType;
        this.children = children;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public boolean isNonTerminal() {
        return true;
    }

    public String toString() {
        if (this.children == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.children.length) {
            String string = this.children[i].toString();
            buffer.append(string);
            if (string.length() > 0 && i < this.children.length - 1) {
                buffer.append(' ');
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.nonTerminalType == 2;
    }

    @Override
    public boolean isError() {
        return this.nonTerminalType == 2 && this.children != null && this.children[0].isError();
    }

    @Override
    public String getText() {
        if (this.children == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.children.length) {
            buffer.append(this.children[i].getText());
            ++i;
        }
        return buffer.toString();
    }
}

