/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.AbstractRecoverer;
import org.eclipse.edt.ide.core.internal.errors.ErrorMarkerCollector;
import org.eclipse.edt.ide.core.internal.errors.ErrorNonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ErrorTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.Reporter;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public class InvalidTerminalRecoverer
extends AbstractRecoverer {
    TerminalNode bestCandidate;
    int bestDistance = -1;

    @Override
    public int recoverDistance(ParseStack stack, TokenStream tokenStream) {
        this.bestCandidate = null;
        this.bestDistance = -1;
        short[] terminalCandidates = this.grammar.getTerminalCandidates(stack.getCurrentState());
        int i = 0;
        while (i < terminalCandidates.length) {
            int curDistance = this.recoveryDistance(terminalCandidates[i], stack, tokenStream);
            if (curDistance > this.bestDistance) {
                this.bestCandidate = new ErrorTerminalNode(terminalCandidates[i]);
                this.bestDistance = curDistance;
            }
            ++i;
        }
        return this.bestDistance;
    }

    private int recoveryDistance(int candidate, ParseStack stack, TokenStream tokenStream) {
        if (InvalidTerminalRecoverer.isImportantTerminal(tokenStream.lookAhead())) {
            return 0;
        }
        stack = stack.copy();
        tokenStream = tokenStream.copy();
        tokenStream.deleteInput(1);
        this.processTerminal(stack, new ErrorTerminalNode(candidate));
        int distance = this.tryParseAhead(stack, tokenStream);
        Reporter.getInstance().invalidTerminalDistance(candidate, distance);
        return distance;
    }

    @Override
    public void recover(ParseStack stack, TokenStream tokenStream) {
        ParseNode errorNode;
        Reporter.getInstance().recoverInvalidTerminal(tokenStream.lookAhead().text, this.bestCandidate.terminalType);
        this.errorMessage(stack, tokenStream, tokenStream.lookAhead());
        tokenStream.deleteInput(1);
        ParseNode[] substitutedSymbols = tokenStream.getUnprocessedTerminals();
        ParseStack tempStack = stack.copy();
        this.processTerminal(tempStack, this.bestCandidate);
        ParseNode highestSymbol = this.getHighestSymbol(tempStack, tokenStream.lookAhead());
        this.performAllReductions(stack, this.bestCandidate);
        ParseNode substitutedNode = this.chainNodes(substitutedSymbols);
        if (highestSymbol.isTerminal()) {
            TerminalNode hsTerminal = (TerminalNode)highestSymbol;
            errorNode = new ErrorTerminalNode(hsTerminal.terminalType, substitutedNode);
        } else {
            NonTerminalNode hsNonTerminal = (NonTerminalNode)highestSymbol;
            errorNode = new ErrorNonTerminalNode(hsNonTerminal.nonTerminalType, substitutedNode);
        }
        stack.shift(errorNode);
    }

    @Override
    public void errorMessage(ParseStack stack, TokenStream tokenStream, TerminalNode errorTerminal) {
        ParseStack tempStack = stack.copy();
        this.processTerminal(tempStack, this.bestCandidate);
        TokenStream tempTokenStream = tokenStream.copy();
        tempTokenStream.deleteInput(1);
        String highestSymbolName = this.getHighestSymbolName(tempStack, tempTokenStream.lookAhead());
        String message = highestSymbolName.toUpperCase().equals(highestSymbolName) ? "\t\"" + errorTerminal + "\" is unexpected, expecting " + EGLNodeNameUtility.getTerminalName(this.bestCandidate.terminalType) + " instead." : "\t\"" + errorTerminal + "\" is an invalid " + highestSymbolName;
        ErrorMarkerCollector.instance.add(errorTerminal.offset, errorTerminal.offset + errorTerminal.text.length(), errorTerminal.line, message);
    }
}

