/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.edt.ide.core.internal.dependency.DependentEntry;
import org.eclipse.edt.ide.core.internal.dependency.Part;
import org.eclipse.edt.ide.core.internal.dependency.SimpleName;

public class SimpleNameDependentEntry
extends DependentEntry {
    private HashMap simpleNames = new HashMap();
    private HashSet files = new HashSet();

    public void addPart(Part filePart, SimpleName partName) {
        HashSet<SimpleName> dependentsByFilePart = (HashSet<SimpleName>)this.simpleNames.get(filePart);
        if (dependentsByFilePart == null) {
            dependentsByFilePart = new HashSet<SimpleName>();
            this.simpleNames.put(filePart, dependentsByFilePart);
            this.files.add(filePart);
        }
        dependentsByFilePart.add(partName);
    }

    public HashSet getFileParts() {
        return this.files;
    }

    public HashSet getParts(Part filePart) {
        return (HashSet)this.simpleNames.get(filePart);
    }

    public void removePart(Part filePart, SimpleName partName) {
        HashSet dependentsByFilePart = (HashSet)this.simpleNames.get(filePart);
        if (dependentsByFilePart != null) {
            dependentsByFilePart.remove(partName);
            if (dependentsByFilePart.size() == 0) {
                this.simpleNames.remove(filePart);
                this.files.remove(filePart);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.simpleNames.size() == 0 && this.files.size() == 0;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.files.size());
        for (Part filePart : this.files) {
            filePart.serialize(outputStream);
            HashSet dependentsByFilePart = (HashSet)this.simpleNames.get(filePart);
            outputStream.writeInt(dependentsByFilePart.size());
            for (SimpleName simpleName : dependentsByFilePart) {
                simpleName.serialize(outputStream);
            }
        }
    }

    @Override
    public void deserialize(DataInputStream inputStream) throws IOException {
        int numFiles = inputStream.readInt();
        int i = 0;
        while (i < numFiles) {
            Part filePart = new Part();
            filePart.deserialize(inputStream);
            int numPartNames = inputStream.readInt();
            int j = 0;
            while (j < numPartNames) {
                SimpleName partName = new SimpleName();
                partName.deserialize(inputStream);
                this.addPart(filePart, partName);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int getKind() {
        return 2;
    }
}

