/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ComparatorWidgetPositions;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.javart.json.JsonParser;
import org.eclipse.edt.javart.json.JsonVisitor;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.ParseException;
import org.eclipse.swt.graphics.Point;

public class WidgetManager {
    protected WidgetPart _widgetRoot = new WidgetPart();
    protected TreeSet _widgetPartsTree = null;
    protected List _listWidgetParts = null;

    public WidgetManager() {
        this._widgetRoot.setTypeName("ROOT");
        this._widgetPartsTree = new TreeSet(new ComparatorWidgetPositions());
        this._listWidgetParts = new ArrayList();
    }

    protected void addChildrenToSortedSet(TreeSet treeset, WidgetPart widgetPart) {
        List listChildren = widgetPart.getChildren();
        int i = 0;
        while (i < listChildren.size()) {
            WidgetPart widgetChild = (WidgetPart)listChildren.get(i);
            treeset.add(widgetChild);
            this.addChildrenToSortedSet(treeset, widgetChild);
            ++i;
        }
    }

    public void addWidget(WidgetPart widgetParent, WidgetPart widgetChild) {
        widgetParent.addChildWidget(widgetChild);
    }

    public WidgetPart getWidget(int iOffset, int iLength) {
        List widgets = this.getWidgetList();
        for (WidgetPart widget : widgets) {
            if (widget.getStatementOffset() != iOffset || widget.getStatementLength() != iLength) continue;
            return widget;
        }
        return null;
    }

    public int getWidgetCount() {
        return this.getWidgetList().size();
    }

    public WidgetPart getWidgetNext(WidgetPart widget) {
        WidgetPart widgetNext;
        block3: {
            widgetNext = null;
            List listChildren = widget.getChildren();
            if (listChildren.size() > 0) {
                widgetNext = (WidgetPart)listChildren.get(0);
            } else {
                int iIndex;
                WidgetPart widgetParent = widget;
                do {
                    widget = widgetParent;
                    if ((widgetParent = widgetParent.getParent()) != null) continue;
                    widgetNext = (WidgetPart)this._widgetRoot.getChildren().get(0);
                    break block3;
                } while ((iIndex = widgetParent.getChildIndex(widget)) >= (listChildren = widgetParent.getChildren()).size() - 1);
                widgetNext = (WidgetPart)listChildren.get(iIndex + 1);
            }
        }
        return widgetNext;
    }

    public WidgetPart getWidgetPrevious(WidgetPart widget) {
        List listChildren;
        WidgetPart widgetPrevious = null;
        WidgetPart widgetParent = widget.getParent();
        int iIndex = widgetParent.getChildIndex(widget);
        if (iIndex == 0) {
            if (widgetParent != this._widgetRoot) {
                return widgetParent;
            }
            widgetPrevious = (WidgetPart)widgetParent.getChildren().get(widgetParent.getChildren().size() - 1);
        } else {
            widgetPrevious = (WidgetPart)widgetParent.getChildren().get(iIndex - 1);
        }
        while ((listChildren = widgetPrevious.getChildren()).size() != 0) {
            widgetPrevious = (WidgetPart)listChildren.get(listChildren.size() - 1);
        }
        return widgetPrevious;
    }

    public WidgetPart getWidgetRoot() {
        return this._widgetRoot;
    }

    public List getWidgetList() {
        return this._listWidgetParts;
    }

    public void getWidgetListRecursive(List listWidgetParts, WidgetPart widgetPart) {
        List listChildren = widgetPart.getChildren();
        int i = 0;
        while (i < listChildren.size()) {
            WidgetPart widgetChild = (WidgetPart)listChildren.get(i);
            listWidgetParts.add(widgetChild);
            this.getWidgetListRecursive(listWidgetParts, widgetChild);
            ++i;
        }
    }

    public boolean isChildOf(WidgetPart child, WidgetPart parent) {
        if (parent == this._widgetRoot && child != this._widgetRoot) {
            return true;
        }
        if (child.getParent() == this._widgetRoot) {
            return false;
        }
        if (child.getParent() == parent) {
            return true;
        }
        return this.isChildOf(child.getParent(), parent);
    }

    public List getWidgets(Point point) {
        ArrayList<WidgetPart> list = new ArrayList<WidgetPart>();
        for (WidgetPart widget : this._widgetPartsTree) {
            if (!widget.getBounds().contains(point)) continue;
            list.add(widget);
        }
        return list;
    }

    public boolean hasWidgets() {
        return !this._widgetRoot.getChildren().isEmpty();
    }

    public void removeAllWidgets() {
        this._widgetRoot.removeAllChildren();
        this._widgetPartsTree.clear();
        this._listWidgetParts.clear();
    }

    protected void removeInvalidWidgets() {
        this.removeInvalidWidgetsRecursive(this._widgetRoot);
    }

    protected void removeInvalidWidgetsRecursive(WidgetPart widget) {
        List listChildren = widget.getChildren();
        int i = listChildren.size() - 1;
        while (i >= 0) {
            this.removeInvalidWidgetsRecursive((WidgetPart)listChildren.get(i));
            --i;
        }
        if (widget != this._widgetRoot && (widget._iStatementOffset < 0 || widget._iStatementLength <= 0)) {
            widget.removeAllChildren();
        }
        if (widget._rectBounds.isEmpty() || widget.getTypeName() == null) {
            this.removeWidget(widget);
        } else if (!(widget._iStatementOffset >= 0 && widget._iStatementLength > 0 || widget.getMoveable())) {
            this.removeWidget(widget);
        }
    }

    public void removeWidget(WidgetPart widgetPart) {
        WidgetPart widgetParent = widgetPart.getParent();
        if (widgetParent == null) {
            return;
        }
        List listChildren = widgetParent.getChildren();
        listChildren.remove(widgetPart);
    }

    public void setWidgetsFromJsonString(String strJson) {
        this.removeAllWidgets();
        try {
            ObjectNode node = JsonParser.parse((String)strJson);
            try {
                node.accept((JsonVisitor)new org.eclipse.edt.ide.rui.visualeditor.internal.jsonvisitors.JsonVisitor(this._widgetRoot));
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (ParseException parseException) {}
        this.addChildrenToSortedSet(this._widgetPartsTree, this._widgetRoot);
        this.getWidgetListRecursive(this._listWidgetParts, this._widgetRoot);
    }
}

