/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;

public class HandlerFieldsResolver {
    private IFile currentFile;
    private Handler ruiHandler;

    public HandlerFieldsResolver(IFile currentFile) {
        this.currentFile = currentFile;
    }

    public void resolve() {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            IEGLFile tempWorkingCopy = (IEGLFile)modelFile.getWorkingCopy();
            tempWorkingCopy.getBuffer().setContents(sharedWorkingCopy.getBuffer().getContents());
            WorkingCopyCompileRequestor requestor = new WorkingCopyCompileRequestor();
            try {
                try {
                    String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                    WorkingCopyCompiler.getInstance().compilePart(this.currentFile.getProject(), Util.stringArrayToQualifiedName((String[])((EGLFile)modelFile).getPackageName()), this.currentFile, new IWorkingCopy[]{tempWorkingCopy}, partName, (IWorkingCopyCompileRequestor)requestor);
                    this.ruiHandler = requestor.getBoundPart();
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Type Name Resolver: Error resolving type name", (Throwable)e));
                    tempWorkingCopy.destroy();
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                tempWorkingCopy.destroy();
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Type Name Resolver: Error resolving type name", (Throwable)e));
        }
    }

    public Handler getRUIHandler() {
        return this.ruiHandler;
    }

    private class WorkingCopyCompileRequestor
    implements IWorkingCopyCompileRequestor {
        Handler boundPageHandler = null;

        private WorkingCopyCompileRequestor() {
        }

        public void acceptResult(WorkingCopyCompilationResult result) {
            this.boundPageHandler = (Handler)result.getBoundPart();
        }

        public Handler getBoundPart() {
            return this.boundPageHandler;
        }
    }
}

