/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class ColorSelectorButton
implements DisposeListener,
SelectionListener {
    public static int PATTERN_NONE = 0;
    public static int PATTERN_HATCH = 1;
    public static int PATTERN_DENTAL = 2;
    protected boolean _bEnabled = true;
    protected Button _button = null;
    protected Color _color = null;
    protected Image _image = null;
    protected int _iPattern = PATTERN_NONE;
    protected Point _ptExtents = null;
    protected ModifyListener _modifyListener = null;
    protected RGB _rgbColorValue = new RGB(128, 128, 128);

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }

    public Button createWidget(Object objParent) {
        if (!(objParent instanceof Composite)) {
            return null;
        }
        this._button = new Button((Composite)objParent, 8);
        this._rgbColorValue = this._button.getBackground().getRGB();
        this._color = new Color((Device)this._button.getDisplay(), this._rgbColorValue);
        this._ptExtents = this.computeImageSize((Control)((Composite)objParent));
        this._image = new Image((Device)this._button.getDisplay(), this._ptExtents.x, this._ptExtents.y);
        GC gc = new GC((Drawable)this._image);
        gc.setBackground(this._button.getBackground());
        gc.fillRectangle(0, 0, this._ptExtents.x, this._ptExtents.y);
        gc.dispose();
        this.updateColorImage();
        this._button.setImage(this._image);
        this._button.addDisposeListener((DisposeListener)this);
        this._button.addSelectionListener((SelectionListener)this);
        return this._button;
    }

    public String getColor() {
        return ColorUtil.getRGBString(this._rgbColorValue);
    }

    public RGB getRGB() {
        return this._rgbColorValue;
    }

    public void initialize() {
        this.updateColorImage();
        this._button.setEnabled(this._bEnabled);
    }

    public void setColor(String strColor) {
        this._rgbColorValue = ColorUtil.convertStringToRGB(strColor);
        if (this._button != null && strColor != null) {
            this.updateColorImage();
        }
    }

    public void setEnabled(boolean bEnabled) {
        this._bEnabled = bEnabled;
        if (this._button != null) {
            this._button.setEnabled(this._bEnabled);
        }
    }

    public void setModifyListener(ModifyListener modifyListener) {
        this._modifyListener = modifyListener;
    }

    public void setPattern(int iPattern) {
        this._iPattern = iPattern;
        this.updateColorImage();
    }

    public void setRGB(RGB rgb) {
        this._rgbColorValue = rgb;
        this.updateColorImage();
    }

    public void setTooltip(String strTooltip) {
        this._button.setToolTipText(strTooltip);
    }

    protected void updateColorImage() {
        Display display = this._button.getDisplay();
        GC gc = new GC((Drawable)this._image);
        if (this._color != null && !this._color.isDisposed()) {
            this._color.dispose();
        }
        this._color = new Color((Device)display, this._rgbColorValue);
        gc.setBackground(this._color);
        gc.fillRectangle(1, 3, this._ptExtents.x - 2, this._ptExtents.y - 5);
        if (this._iPattern != PATTERN_NONE) {
            int iBlu;
            int iGrn;
            int iRed = this._color.getRed();
            double dLuminance = 0.3 * (double)iRed + 0.59 * (double)(iGrn = this._color.getGreen()) + 0.11 * (double)(iBlu = this._color.getBlue());
            boolean bWhite = dLuminance < 150.0;
            gc.setLineStyle(1);
            gc.setLineWidth(1);
            gc.setForeground(Display.getCurrent().getSystemColor(bWhite ? 1 : 2));
            if (this._iPattern == PATTERN_HATCH) {
                int i = 4;
                while (i < this._ptExtents.x - 4) {
                    gc.drawLine(i, 2, i, this._ptExtents.y - 2);
                    i += 4;
                }
                i = 4;
                while (i < this._ptExtents.y - 5) {
                    gc.drawLine(0, 2 + i, this._ptExtents.x - 2, 2 + i);
                    i += 4;
                }
            } else if (this._iPattern == PATTERN_DENTAL) {
                gc.setLineStyle(3);
                gc.setLineWidth(3);
                gc.drawLine(0, 3, this._ptExtents.x, 3);
                gc.drawLine(0, this._ptExtents.y - 3, this._ptExtents.x, this._ptExtents.y - 3);
            }
        }
        gc.setLineStyle(1);
        gc.setLineWidth(1);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(0, 2, this._ptExtents.x - 1, this._ptExtents.y - 4);
        gc.dispose();
        this._button.setImage(this._image);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._color != null && !this._color.isDisposed()) {
            this._color.dispose();
            this._color = null;
        }
        if (this._image != null && !this._image.isDisposed()) {
            this._image.dispose();
            this._image = null;
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this._button.isDisposed()) {
            return;
        }
        ColorDialog colorDialog = new ColorDialog(this._button.getShell());
        colorDialog.setRGB(this._rgbColorValue);
        RGB rgbSelected = colorDialog.open();
        if (rgbSelected != null) {
            this._rgbColorValue = rgbSelected;
            this.updateColorImage();
            if (this._modifyListener != null) {
                Event event = new Event();
                event.widget = this._button;
                this._modifyListener.modifyText(new ModifyEvent(event));
            }
        }
    }
}

