/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization.binary;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.impl.EObjectImpl;
import org.eclipse.edt.mof.impl.NullableSlot;
import org.eclipse.edt.mof.impl.Slot;
import org.eclipse.edt.mof.serialization.SerializationException;
import org.eclipse.edt.mof.serialization.Serializer;

public class BinarySerializer
implements Serializer {
    HashMap constantPoolMap;
    List constantPoolList;
    HashMap<EObject, Integer> eObjectMap;
    List<EObject> eObjectList;
    OutputStream outputStream;
    ByteArrayOutputStream byteStream;

    @Override
    public void serialize(EObject object) throws SerializationException {
        this.byteStream = new ByteArrayOutputStream();
        this.outputStream = new BufferedOutputStream(this.byteStream);
        this.writeUint2(649);
        this.writeEObject(object);
        byte[] objectBytes = this.getContents();
        this.byteStream = new ByteArrayOutputStream();
        this.outputStream = new BufferedOutputStream(this.byteStream);
        this.primSerialize(objectBytes);
    }

    private List getConstantPoolList() {
        if (this.constantPoolList == null) {
            this.constantPoolList = new ArrayList();
            this.constantPoolList.add(null);
        }
        return this.constantPoolList;
    }

    private HashMap getConstantPoolMap() {
        if (this.constantPoolMap == null) {
            this.constantPoolMap = new HashMap();
        }
        return this.constantPoolMap;
    }

    private List<EObject> getEObjectList() {
        if (this.eObjectList == null) {
            this.eObjectList = new ArrayList<EObject>();
        }
        return this.eObjectList;
    }

    private HashMap<EObject, Integer> getEObjectMap() {
        if (this.eObjectMap == null) {
            this.eObjectMap = new HashMap();
        }
        return this.eObjectMap;
    }

    private void primSerialize(byte[] partBytes) throws SerializationException {
        this.writeMagic();
        this.writeVersion();
        this.writePool();
        this.writeUint4(this.eObjectList.size());
        this.writeBytes(partBytes);
    }

    private void writeVersion() throws SerializationException {
        this.writeUint2(9);
        this.writeUint2(10000);
    }

    private void writePool() throws SerializationException {
        int size = this.getConstantPoolList().size();
        if (this.isLargerThanUint4(size)) {
            throw new SerializationException("Constant pool too large");
        }
        this.writeUint4(size + 1);
        for (Object obj : this.getConstantPoolList()) {
            if (obj == null) {
                this.writeUint2(998);
                continue;
            }
            if (!(obj instanceof String)) continue;
            this.writeString((String)obj);
        }
    }

    private void writeMagic() throws SerializationException {
        this.writeUint4(3405700781L);
    }

    private void writeString(String string) throws SerializationException {
        try {
            this.writeUint2(650);
            this.writeBytesWithLength(string.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private void writeUint2(int integer) throws SerializationException {
        byte[] buf = new byte[]{(byte)((integer & 0xFF00) >> 8), (byte)(integer & 0xFF)};
        this.writeBytes(buf);
    }

    private void writeUint4(long aLong) throws SerializationException {
        byte[] buf = new byte[]{(byte)((aLong & 0xFF000000L) >> 24), (byte)((aLong & 0xFF0000L) >> 16), (byte)((aLong & 0xFF00L) >> 8), (byte)(aLong & 0xFFL)};
        this.writeBytes(buf);
    }

    public byte[] getContents() throws SerializationException {
        try {
            this.outputStream.flush();
            byte[] bytes = this.byteStream.toByteArray();
            this.outputStream.close();
            return bytes;
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private void writeBytes(byte[] bytes) throws SerializationException {
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    private void writeBytesWithLength(byte[] bytes) throws SerializationException {
        this.writeUint2(bytes.length);
        this.writeBytes(bytes);
    }

    private void writePoolIndex(Object obj) throws SerializationException {
        this.writeUint4(this.getPoolIndex(obj));
    }

    private int getPoolIndex(Object object) {
        if (object == null) {
            return 0;
        }
        Integer i = (Integer)this.getConstantPoolMap().get(object);
        if (i != null) {
            return i;
        }
        int len = this.getConstantPoolList().size();
        this.getConstantPoolList().add(object);
        this.getConstantPoolMap().put(object, new Integer(len));
        return len;
    }

    private void writeEObject(EObject object) throws SerializationException {
        Integer i = this.getEObjectMap().get(object);
        if (i == null) {
            i = this.getEObjectList().size();
            this.getEObjectMap().put(object, this.getEObjectList().size());
            this.eObjectList.add(object);
        }
        this.writeUint4(i.intValue());
        this.writeEObjectSlots(object.getEClass(), ((EObjectImpl)object).getSlots());
    }

    private void writeObject(Object object) throws SerializationException {
        this.writeObject(object, false);
    }

    private void writeObject(Object object, boolean containment) throws SerializationException {
        if (object == null) {
            this.writeUint2(998);
            return;
        }
        if (object instanceof EObject) {
            if (containment) {
                this.writeUint2(649);
                this.writeEObject((EObject)object);
            } else {
                Integer i = this.getEObjectMap().get((EObject)object);
                if (i == null) {
                    if (object instanceof MofSerializable) {
                        this.writeUint2(997);
                        String key = ((MofSerializable)object).getMofSerializationKey();
                        this.writePoolIndex(key);
                        return;
                    }
                    i = this.getEObjectList().size();
                    this.eObjectList.add((EObject)object);
                    this.getEObjectMap().put((EObject)object, i);
                }
                this.writeUint2(648);
                this.writeUint4(i.intValue());
            }
            return;
        }
        if (object instanceof Slot) {
            if (object instanceof NullableSlot) {
                this.writeUint2(674);
                this.writeObject(((Slot)object).isNull(), containment);
            } else {
                this.writeUint2(673);
            }
            this.writeObject(((Slot)object).get(), containment);
            return;
        }
        if (object instanceof String) {
            this.writeUint2(999);
            this.writePoolIndex(object);
            return;
        }
        if (object instanceof BigInteger) {
            this.writeUint2(651);
            this.writePoolIndex(((BigInteger)object).toString());
            return;
        }
        if (object instanceof Long) {
            this.writeUint2(652);
            this.writePoolIndex(((Long)object).toString());
            return;
        }
        if (object instanceof Integer) {
            this.writeUint2(653);
            this.writePoolIndex(((Integer)object).toString());
            return;
        }
        if (object instanceof Float) {
            this.writeUint2(654);
            this.writePoolIndex(((Float)object).toString());
            return;
        }
        if (object instanceof Double) {
            this.writeUint2(655);
            this.writePoolIndex(((Double)object).toString());
            return;
        }
        if (object instanceof BigDecimal) {
            this.writeUint2(656);
            this.writePoolIndex(((BigDecimal)object).toString());
            return;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                this.writeUint2(659);
            } else {
                this.writeUint2(660);
            }
            return;
        }
        if (object instanceof Enum) {
            this.writeUint2(18);
            this.writePoolIndex(((Enum)object).getClass().getName());
            this.writePoolIndex(((Enum)object).name());
            return;
        }
        if (object instanceof Integer[]) {
            this.writeUint2(662);
            this.writeIntegerArray((Integer[])object);
            return;
        }
        if (object instanceof Integer[][]) {
            this.writeUint2(663);
            this.writeIntegerArrayArray((Integer[][])object);
            return;
        }
        if (object instanceof String[]) {
            this.writeUint2(664);
            this.writeStringArray((String[])object);
            return;
        }
        if (object instanceof String[][]) {
            this.writeUint2(665);
            this.writeStringArrayArray((String[][])object);
            return;
        }
        if (object instanceof Slot[]) {
            this.writeUint2(672);
            this.writeObjectArray((Object[])object);
            return;
        }
        if (object instanceof Object[]) {
            this.writeUint2(666);
            this.writeObjectArray((Object[])object);
            return;
        }
        if (object instanceof List) {
            this.writeUint2(671);
            this.writeList((List)object, containment);
            return;
        }
        System.err.println("PRH - object = " + object.getClass().toString());
        this.writeObject("UNKNOWN SERIALIZATION TYPE: " + object.getClass());
    }

    private void writeEObjectSlots(EClass eClass, Slot[] slots) {
        this.writeUint2(672);
        this.writeUint2(slots.length);
        int i = 0;
        while (i < slots.length) {
            Slot slot = slots[i];
            EField field = eClass.getEField(i);
            if (!field.isTransient()) {
                this.writeObject(slot, field.getContainment());
            } else if (field.getEClass() instanceof EDataType) {
                this.writeObject(((EDataType)((Object)field.getEClass())).getDefaultValue());
            } else {
                this.writeObject(null);
            }
            ++i;
        }
    }

    private void writeIntegerArray(Integer[] arr) throws SerializationException {
        this.writeUint2(arr.length);
        int i = 0;
        while (i < arr.length) {
            this.writePoolIndex(arr[i].toString());
            ++i;
        }
    }

    private void writeIntegerArrayArray(Integer[][] arr) throws SerializationException {
        this.writeUint2(arr.length);
        int i = 0;
        while (i < arr.length) {
            this.writeIntegerArray(arr[i]);
            ++i;
        }
    }

    private void writeStringArray(String[] arr) throws SerializationException {
        this.writeUint2(arr.length);
        int i = 0;
        while (i < arr.length) {
            this.writePoolIndex(arr[i]);
            ++i;
        }
    }

    private void writeStringArrayArray(String[][] arr) throws SerializationException {
        this.writeUint2(arr.length);
        int i = 0;
        while (i < arr.length) {
            this.writeStringArray(arr[i]);
            ++i;
        }
    }

    private void writeObjectArray(Object[] arr) throws SerializationException {
        this.writeUint2(arr.length);
        int i = 0;
        while (i < arr.length) {
            this.writeObject(arr[i]);
            ++i;
        }
    }

    private void writeList(List list, boolean containment) {
        this.writeUint2(list.size());
        int i = 0;
        while (i < list.size()) {
            this.writeObject(list.get(i), containment);
            ++i;
        }
    }

    private boolean isLargerThanUint4(int anInt) {
        return (anInt & 0xF0000000) != 0;
    }
}

