/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.mof.serialization.AbstractObjectStore;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.Serializer;

public class MemoryObjectStore
extends AbstractObjectStore
implements ObjectStore {
    protected Map<String, byte[]> bytes = new HashMap<String, byte[]>();

    public MemoryObjectStore(IEnvironment env) {
        super(env);
    }

    public MemoryObjectStore(IEnvironment env, String storageFormat) {
        super(env, storageFormat);
    }

    @Override
    public Deserializer createDeserializer(String key) {
        byte[] obj = this.bytes.get(key);
        if (obj == null) {
            return null;
        }
        return this.factory.createDeserializer(new ByteArrayInputStream(obj), this.env);
    }

    public Serializer createSerializer() {
        return this.factory.createSerializer();
    }

    @Override
    public void store(String key, Object obj) {
        if (!(obj instanceof byte[])) {
            throw new IllegalArgumentException("Object not of type: byte[]");
        }
        this.bytes.put(key, (byte[])obj);
    }

    @Override
    public void primRemove(String key) {
        this.bytes.remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.bytes.containsKey(key);
    }

    @Override
    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        return new ArrayList<String>();
    }
}

