/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class SimpleWriter {
    private Writer writer;
    private int lineNumber;
    private static final char[] NEWLINE = new char[]{'\n'};

    public SimpleWriter(String fileName) throws Exception {
        try {
            this.writer = new BufferedWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            throw new Exception("Exception thrown in SimpleWriter: " + e.getMessage());
        }
        this.lineNumber = 1;
    }

    public SimpleWriter(Writer writer) {
        this.writer = writer;
    }

    public void close() throws Exception {
        this.writer.close();
    }

    public void flush() throws Exception {
        this.writer.flush();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void print(String str) throws Exception {
        this.print(str.toCharArray());
    }

    public void print(char[] chars) throws Exception {
        this.printManuallyIndented(chars);
    }

    public void print(char c) throws Exception {
        this.print(new char[]{c});
    }

    public void print(int i) throws Exception {
        this.print(Integer.toString(i).toCharArray());
    }

    public void print(boolean b) throws Exception {
        if (b) {
            this.print("true");
        } else {
            this.print("false");
        }
    }

    public void println() throws Exception {
        this.print(NEWLINE);
    }

    public void println(String str) throws Exception {
        this.print(str);
        this.print(NEWLINE);
    }

    public void println(char[] chars) throws Exception {
        this.print(chars);
        this.print(NEWLINE);
    }

    public void println(char c) throws Exception {
        this.print(new char[]{c, '\n'});
    }

    public void println(int i) throws Exception {
        this.print(Integer.toString(i).toCharArray());
        this.print(NEWLINE);
    }

    public void println(boolean b) throws Exception {
        this.print(b);
        this.print(NEWLINE);
    }

    private void printManuallyIndented(char[] ch) throws Exception {
        int currentStart = 0;
        int end = ch.length;
        try {
            int i = 0;
            while (i < end) {
                if (ch[i] == '\n') {
                    this.writer.write(ch, currentStart, i + 1 - currentStart);
                    currentStart = i + 1;
                    ++this.lineNumber;
                }
                ++i;
            }
            if (end > currentStart && ch[end - 1] != '\n') {
                this.writer.write(ch, currentStart, end - currentStart);
            }
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }
}

