/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.wizards.EGLContainerConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

public class EGLSourceFolderConfiguration
extends EGLContainerConfiguration {
    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IEGLProject eproject;
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        Object selectedElement = selection.getFirstElement();
        String projPath = null;
        if (selectedElement instanceof IResource) {
            IProject proj = ((IResource)selectedElement).getProject();
            if (proj != null) {
                projPath = proj.getFullPath().makeRelative().toString();
            }
        } else if (selectedElement instanceof IEGLElement) {
            IEGLProject eproject2 = ((IEGLElement)selectedElement).getEGLProject();
            if (eproject2 != null) {
                projPath = eproject2.getProject().getFullPath().makeRelative().toOSString();
            }
        } else if (selectedElement instanceof IJavaProject && (eproject = EGLCore.create((IProject)((IJavaProject)selectedElement).getProject())) != null && eproject.exists()) {
            projPath = eproject.getProject().getFullPath().makeRelative().toOSString();
        }
        if (projPath != null) {
            this.setProjectName(projPath);
            this.setSourceFolderName("");
        } else {
            this.setDefaultAttributes();
        }
    }

    private void setDefaultAttributes() {
        String projPath = "";
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject proj = projects[i];
                if (proj.hasNature(EGLCore.NATURE_ID)) {
                    projPath = proj.getFullPath().makeRelative().toString();
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        this.setProjectName(projPath);
        this.setSourceFolderName("");
    }
}

