/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AddProjectDependencyOperation
extends WorkspaceModifyOperation {
    private ProjectConfiguration projectConfiguration;
    private String widgetProject;

    public AddProjectDependencyOperation(ProjectConfiguration projectConfiguration, ISchedulingRule rule, String widgetProject) {
        super(rule);
        this.widgetProject = widgetProject;
        this.projectConfiguration = projectConfiguration;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IProject widgetsProject;
        IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IEGLProject eglProject = EGLCore.create((IProject)fWorkspaceRoot.getProject(this.projectConfiguration.getProjectName()));
        if (this.widgetProject != null && (widgetsProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.widgetProject)).exists()) {
            AddProjectDependencyOperation.addRequiredProject(eglProject, fWorkspaceRoot.getProject(this.widgetProject), false);
        }
    }

    private static void addRequiredProject(IEGLProject sourceProject, IProject reqProject, boolean isExported) throws CoreException {
        String[] requiredProjectNames = sourceProject.getRequiredProjectNames();
        int i = 0;
        while (i < requiredProjectNames.length) {
            if (requiredProjectNames[i].equals(reqProject.getName())) {
                return;
            }
            ++i;
        }
        IEGLPathEntry[] rawEGLPath = sourceProject.getRawEGLPath();
        IEGLPathEntry[] newEGLPath = new IEGLPathEntry[rawEGLPath.length + 1];
        System.arraycopy(rawEGLPath, 0, newEGLPath, 0, rawEGLPath.length);
        newEGLPath[newEGLPath.length - 1] = EGLCore.newProjectEntry((IPath)reqProject.getProject().getFullPath(), (boolean)isExported);
        sourceProject.setRawEGLPath(newEGLPath, null);
    }
}

