/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.datatools.connectivity.ui.actions.ViewPropertyAction;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ConnectionDisplayProperty;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.sql.SQLNlsStrings;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.util.UISQLUtility;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.BindingSQLDatabaseConfiguration;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SQLDatabaseBindingWizardPage
extends EGLDDBindingWizardPage
implements Listener {
    public static final String WIZPAGENAME_SQLDatabaseBindingWizardPage = "WIZPAGENAME_SQLDatabaseBindingWizardPage";
    private Button newButton;
    private Button editButton;
    private TreeViewer existingConnectionsList;
    private Label propertiesLabel;
    private Table connectionPropertiesTable;
    private Hashtable existingConnections;
    private Button connProfileUriRadio;
    private Button connProfileInlinedRadio;
    private Group connectionGroup;
    private ControlEnableState connectionGroupEnablement;

    public SQLDatabaseBindingWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.TitleAddSQLDatabaseBinding);
        this.setDescription(NewWizardMessages.DescAddSQLDatabaseBinding);
        this.nColumns = 2;
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.MODULE_SQLDATABASEBINDING);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createBindingChoiceSection(composite);
        this.createConnectionGroup(composite);
        this.initializeValues();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createBindingChoiceSection(Composite parent) {
        Label l = new Label(parent, 64);
        l.setText(NewWizardMessages.SQLBindingDescription);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        l.setLayoutData((Object)gd);
        Label spacer = new Label(parent, 64);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.connProfileUriRadio = new Button(parent, 16);
        this.connProfileUriRadio.setText(NewWizardMessages.SQLBindingWorkspaceUriLabel);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        this.connProfileUriRadio.setLayoutData((Object)gd);
        this.connProfileUriRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingWizardPage.this.handleWorkspaceURIRadio();
                if (SQLDatabaseBindingWizardPage.this.connectionGroupEnablement != null) {
                    SQLDatabaseBindingWizardPage.this.connectionGroupEnablement.restore();
                    SQLDatabaseBindingWizardPage.this.connectionGroupEnablement = null;
                }
            }
        });
        this.connProfileInlinedRadio = new Button(parent, 16);
        this.connProfileInlinedRadio.setText(NewWizardMessages.SQLBindingHardcodedLabel);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        this.connProfileInlinedRadio.setLayoutData((Object)gd);
        this.connProfileInlinedRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingWizardPage.this.handleInlinedRadio();
                if (SQLDatabaseBindingWizardPage.this.connectionGroupEnablement != null) {
                    SQLDatabaseBindingWizardPage.this.connectionGroupEnablement.restore();
                    SQLDatabaseBindingWizardPage.this.connectionGroupEnablement = null;
                }
            }
        });
    }

    private void handleWorkspaceURIRadio() {
        this.getConfiguration().setUseUri(true);
        this.updateConnectionProperties();
        this.determinePageCompletion();
    }

    private void handleInlinedRadio() {
        this.getConfiguration().setUseUri(false);
        this.updateConnectionProperties();
        this.determinePageCompletion();
    }

    private void createConnectionGroup(Composite parent) {
        Composite groupParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        groupParent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = this.nColumns;
        groupParent.setLayoutData((Object)data);
        this.connectionGroup = new Group(groupParent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.connectionGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        this.connectionGroup.setLayoutData((Object)gd);
        this.connectionGroup.setText(SQLNlsStrings.SQL_CONNECTION_LABEL_GROUP);
        Composite groupComp = new Composite((Composite)this.connectionGroup, 0);
        GridData gdComp = new GridData(1808);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 2;
        groupComp.setLayout((Layout)gl2);
        groupComp.setLayoutData((Object)gdComp);
        this.createConnectionSection(groupComp);
        this.createPropertySection(groupComp);
        Composite buttonComp = new Composite((Composite)this.connectionGroup, 0);
        GridLayout gl3 = new GridLayout();
        buttonComp.setLayout((Layout)gl3);
        GridData gd3 = new GridData(2);
        buttonComp.setLayoutData((Object)gd3);
        this.createButtons(buttonComp);
    }

    private void initializeValues() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        if (profiles != null && profiles.length > 0) {
            TreeItem item;
            this.updateTreeData();
            IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
            String connectionName = store.getString("org.eclipse.edt.ide.sql.connectionNamedConnection");
            if (connectionName.length() != 0 && this.existingConnections.containsKey(connectionName) && (item = this.findTreeItemByName(this.existingConnectionsList.getTree().getItems(), connectionName)) != null) {
                this.existingConnectionsList.getTree().setSelection(item);
                this.updateConnectionProperties();
            }
            if (this.existingConnectionsList.getTree().getSelectionCount() > 0) {
                this.enableConnectionsControls(true, true);
            } else {
                this.enableConnectionsControls(false, true);
            }
        } else {
            this.enableConnectionsControls(false, false);
        }
        this.connProfileUriRadio.setSelection(true);
        this.handleWorkspaceURIRadio();
    }

    private void createConnectionSection(Composite parent) {
        this.existingConnectionsList = new TreeViewer(parent, 2560);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        this.existingConnectionsList.getTree().setLayoutData((Object)gd);
        this.existingConnectionsList.getTree().addListener(13, (Listener)this);
    }

    private void createButtons(Composite parent) {
        this.newButton = new Button(parent, 8);
        this.newButton.setText(SQLNlsStrings.SQL_CONNECTION_NEW_BUTTON);
        GridData gd = new GridData(768);
        this.newButton.setLayoutData((Object)gd);
        this.newButton.addListener(13, (Listener)this);
        this.editButton = new Button(parent, 8);
        this.editButton.setText(SQLNlsStrings.SQL_CONNECTION_EDIT_BUTTON);
        GridData gd3 = new GridData(768);
        this.editButton.setLayoutData((Object)gd3);
        this.editButton.addListener(13, (Listener)this);
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source.equals(this.newButton)) {
            IConnectionProfile newProfile = EGLSQLUtility.createNewProfile();
            if (newProfile != null) {
                this.updateTreeData();
                TreeItem item = this.findTreeItemByName(this.existingConnectionsList.getTree().getItems(), newProfile.getName());
                if (item != null) {
                    this.existingConnectionsList.getTree().select(item);
                }
                this.updateConnectionProperties();
                this.enableConnectionsControls(true, true);
            }
        } else if (source.equals(this.editButton)) {
            ViewPropertyAction editConnectionProfileAction = new ViewPropertyAction((Viewer)this.existingConnectionsList);
            editConnectionProfileAction.run();
            this.updateTreeData();
        } else if (source.equals(this.existingConnectionsList.getTree())) {
            this.updateConnectionProperties();
        }
        this.determinePageCompletion();
    }

    private void updateTreeData() {
        IConnectionProfile currentSelection = this.getSelectedConnection();
        this.existingConnectionsList.getTree().removeAll();
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        this.existingConnections = new Hashtable();
        for (IConnectionProfile connection : Arrays.asList(profiles)) {
            this.existingConnections.put(connection.getName(), connection);
        }
        Object[] sortedNames = this.sortItems(this.existingConnections.keySet().toArray());
        int index = 0;
        while (index < sortedNames.length) {
            String name = (String)sortedNames[index];
            IConnectionProfile profile = (IConnectionProfile)this.existingConnections.get(name);
            TreeItem item = new TreeItem(this.existingConnectionsList.getTree(), 0);
            item.setText(name);
            item.setData(this.existingConnections.get(name));
            item.setImage(ProfileImageRegistry.getInstance().getProfileImage(profile.getProvider()));
            if (currentSelection != null && profile == currentSelection) {
                this.existingConnectionsList.getTree().setSelection(item);
            }
            ++index;
        }
    }

    private IConnectionProfile getSelectedConnection() {
        IConnectionProfile profile = null;
        TreeItem[] selection = this.existingConnectionsList.getTree().getSelection();
        if (selection.length > 0) {
            profile = (IConnectionProfile)selection[0].getData();
        }
        return profile;
    }

    private Object[] sortItems(Object[] names) {
        Arrays.sort(names, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int result = -1;
                if (arg0 != null && arg1 != null) {
                    result = ((String)arg0).compareToIgnoreCase((String)arg1);
                }
                return result;
            }
        });
        return names;
    }

    private TreeItem findTreeItemByName(TreeItem[] items, String name) {
        TreeItem foundItem = null;
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(name)) {
                foundItem = items[i];
                break;
            }
            ++i;
        }
        return foundItem;
    }

    private void updateConnectionProperties() {
        this.connectionPropertiesTable.removeAll();
        int selectionCount = this.existingConnectionsList.getTree().getSelectionCount();
        if (selectionCount == 0) {
            this.enableConnectionsControls(false, true);
        } else if (selectionCount > 0) {
            ConnectionDisplayProperty[] properties;
            this.enableConnectionsControls(true, true);
            IConnectionProfile profile = this.getSelectedConnection();
            if (profile != null && (properties = EGLSQLUtility.getConnectionDisplayProperties((IConnectionProfile)profile)) != null) {
                int propertyCount = properties.length;
                int index = 0;
                while (index < propertyCount) {
                    TableItem tableItem = new TableItem(this.connectionPropertiesTable, 0);
                    if (SQLNlsStrings.SQL_CONNECTION_USER_PASSWORD_PROPERTY.equals(properties[index].getPropertyName()) && properties[index].getValue() != null) {
                        StringBuilder builder = new StringBuilder();
                        int i = 0;
                        while (i < properties[index].getValue().length()) {
                            builder.append("*");
                            ++i;
                        }
                        tableItem.setText(new String[]{properties[index].getPropertyName(), builder.toString()});
                    } else {
                        tableItem.setText(new String[]{properties[index].getPropertyName(), properties[index].getValue()});
                    }
                    ++index;
                }
                if (this.connProfileInlinedRadio.getSelection()) {
                    UISQLUtility.setBindingSQLDatabaseConfiguration(this.getConfiguration(), properties);
                } else if (this.connProfileUriRadio.getSelection()) {
                    this.getConfiguration().setBindingName(profile.getName());
                    this.getConfiguration().setUri("workspace://" + profile.getName());
                }
            }
        }
    }

    private void enableConnectionsControls(boolean isEnabled, boolean enableTree) {
        this.existingConnectionsList.getTree().setEnabled(enableTree);
        this.propertiesLabel.setEnabled(isEnabled);
        this.connectionPropertiesTable.setEnabled(isEnabled);
        this.editButton.setEnabled(isEnabled);
    }

    private void createPropertySection(Composite parent) {
        this.propertiesLabel = new Label(parent, 0);
        this.propertiesLabel.setText(SQLNlsStrings.SQL_CONNECTION_LABEL_PROPERTIES);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.propertiesLabel.setLayoutData((Object)gd);
        this.connectionPropertiesTable = new Table(parent, 2048);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.connectionPropertiesTable.setLayoutData((Object)gd);
        this.connectionPropertiesTable.setLinesVisible(true);
        this.connectionPropertiesTable.setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this.connectionPropertiesTable, 0);
        tc1.setText(SQLNlsStrings.SQL_CONNECTION_COLUMN_PROPERTY);
        tc1.setResizable(true);
        tc1.setWidth(140);
        TableColumn tc2 = new TableColumn(this.connectionPropertiesTable, 0);
        tc2.setText(SQLNlsStrings.SQL_CONNECTION_COLUMN_VALUE);
        tc2.setResizable(true);
        tc2.setWidth(350);
    }

    @Override
    protected boolean determinePageCompletion() {
        this.setErrorMessage(null);
        boolean result = true;
        if ((this.connProfileInlinedRadio.getSelection() || this.connProfileUriRadio.getSelection()) && this.getSelectedConnection() == null) {
            this.setErrorMessage(NewWizardMessages.SQLBindingNoConnectionSelected);
            result = false;
        }
        this.setPageComplete(result);
        return result;
    }

    private BindingSQLDatabaseConfiguration getConfiguration() {
        return (BindingSQLDatabaseConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(this.getName());
    }

    protected BindingSQLDatabaseConfiguration getBindingSQLDatabaseConfiguration() {
        return (BindingSQLDatabaseConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(WIZPAGENAME_SQLDatabaseBindingWizardPage);
    }
}

