/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.List;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizard;
import org.eclipse.edt.ide.ui.internal.wizards.ExtractInterfaceWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceFrExternalTypeConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ExtractInterfaceFrExternalTypeWizardPage
extends ExtractInterfaceWizardPage {
    public static final String WIZPAGENAME_ExtractInterfaceFrExternalTypeWizardPage = "WIZPAGENAME_ExtractInterfaceFrExternalTypeWizardPage";
    private int nColumns = 5;

    public ExtractInterfaceFrExternalTypeWizardPage(String pageName) {
        super(pageName);
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_EXTRACT_INTERFACE_FR_ET);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, this.nColumns);
        this.createPackageControls(composite);
        this.createSeparator(composite, this.nColumns);
        this.createEGLFileControls(composite);
        this.createTabControls(composite);
        this.createCheckBoxOverwriteFileControl(composite);
        this.createUpdateEGLPathControls(composite);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    private ExtractInterfaceFrExternalTypeConfiguration getConfiguration() {
        return (ExtractInterfaceFrExternalTypeConfiguration)((EGLFileWizard)this.getWizard()).getConfiguration(this.getName());
    }

    @Override
    protected EGLFileConfiguration getFileConfiguration() {
        return this.getConfiguration();
    }

    @Override
    protected void createTabItems(CTabFolder tabfolder) {
        List extractInterfaceConfigs = this.getConfiguration().getExtractInterfaceConfigurations();
        int interfaceCnt = extractInterfaceConfigs.size();
        if (this.tabControls == null) {
            this.tabControls = new Composite[interfaceCnt];
        }
        if (interfaceCnt != this.tabControls.length) {
            this.tabControls = new Composite[interfaceCnt];
        }
        int i = 0;
        for (ExtractInterfaceConfiguration extractInterfaceConfig : extractInterfaceConfigs) {
            String interfaceName = extractInterfaceConfig.getInterfaceName();
            this.createTabItem(tabfolder, i, interfaceName, interfaceName, (ILabelProvider)new ExtractInterfaceWizardPage.ExtractFunctionsListLabelProvider(this, extractInterfaceConfig));
            ++i;
        }
    }

    @Override
    protected void populateFuncList(int index, CheckedListDialogField funcListField) {
        funcListField.removeAllElements();
        ExtractInterfaceConfiguration eConfig = (ExtractInterfaceConfiguration)this.getConfiguration().getExtractInterfaceConfigurations().get(index);
        List funcs = eConfig.getFFunctions();
        int i = 0;
        while (i < funcs.size()) {
            boolean isChecked = eConfig.getFunctionSelectionState(i);
            funcListField.addElement(funcs.get(i));
            funcListField.setChecked(funcs.get(i), isChecked);
            ++i;
        }
    }

    @Override
    protected void handleInterfaceNameDialogFieldChanged(int index, StringDialogField field) {
        ExtractInterfaceConfiguration eConfig = (ExtractInterfaceConfiguration)this.getConfiguration().getExtractInterfaceConfigurations().get(index);
        eConfig.setInterfaceName(field.getText());
        this.validatePage();
    }

    @Override
    protected void handleFunctionListFieldChanged(int index, CheckedListDialogField funcListField) {
        ExtractInterfaceConfiguration eConfig = (ExtractInterfaceConfiguration)this.getConfiguration().getExtractInterfaceConfigurations().get(index);
        int size = funcListField.getSize();
        int i = 0;
        while (i < size) {
            boolean isChecked = funcListField.isChecked(funcListField.getElement(i));
            eConfig.setFunctionsSelectionState(i, isChecked);
            ++i;
        }
    }
}

