/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.wizards.EGLElementConfiguration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class EGLElementWizard
extends Wizard
implements INewWizard {
    EGLElementConfiguration configuration;

    protected void openResource(final IFile resource) {
        Display display;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage activePage = window == null ? null : window.getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        EGLLogger.log((Object)this, e.toString());
                    }
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
    }

    public EGLElementConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new EGLElementConfiguration();
        }
        return this.configuration;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }
}

