/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.EDTRuntimeContainerEntry;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EDTRuntimeContainerWizardPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IClasspathEntry currentEntry;
    private EDTRuntimeContainer[] availableLibraries;
    private Combo runtimeCombo;
    private Label description;
    private Label path;

    public EDTRuntimeContainerWizardPage() {
        super("EDTRuntimeWizardPage");
        this.setTitle(NewWizardMessages.EDTRuntimeContainerPage_Title);
        this.setDescription(NewWizardMessages.EDTRuntimeContainerPage_Description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        IGenerator[] gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
        if (gens != null && gens.length != 0) {
            HashSet<EDTRuntimeContainer> allLibs = new HashSet<EDTRuntimeContainer>();
            int i = 0;
            while (i < gens.length) {
                EDTRuntimeContainer[] libs = gens[i].getRuntimeContainers();
                if (libs != null && libs.length != 0) {
                    int j = 0;
                    while (j < libs.length) {
                        allLibs.add(libs[j]);
                        ++j;
                    }
                }
                ++i;
            }
            this.availableLibraries = allLibs.toArray(new EDTRuntimeContainer[allLibs.size()]);
            Arrays.sort(this.availableLibraries);
        } else {
            this.availableLibraries = new EDTRuntimeContainer[0];
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.availableLibraries.length == 0) {
            new Label(composite, 0).setText(NewWizardMessages.EDTRuntimeContainerPage_NoRuntimes);
            this.updateStatus(new StatusInfo(4, ""));
        } else {
            Label label = new Label(composite, 0);
            label.setText(NewWizardMessages.EDTRuntimeContainerPage_LibraryLabel);
            label.setFont(composite.getFont());
            this.runtimeCombo = new Combo(composite, 8);
            this.runtimeCombo.setFont(composite.getFont());
            this.runtimeCombo.setLayoutData((Object)new GridData(768));
            this.runtimeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EDTRuntimeContainerWizardPage.this.selectionChanged();
                }
            });
            label = new Label(composite, 0);
            label.setText(NewWizardMessages.EDTRuntimeContainerPage_DescriptionLabel);
            label.setFont(composite.getFont());
            this.description = new Label(composite, 64);
            this.description.setFont(composite.getFont());
            this.description.setLayoutData((Object)new GridData(768));
            label = new Label(composite, 0);
            label.setText(NewWizardMessages.EDTRuntimeContainerPage_PathsLabel);
            label.setFont(composite.getFont());
            label.setLayoutData((Object)new GridData(1, 128, false, false));
            this.path = new Label(composite, 64);
            this.path.setFont(composite.getFont());
            this.path.setLayoutData((Object)new GridData(1808));
            String[] items = new String[this.availableLibraries.length];
            int i = 0;
            while (i < items.length) {
                items[i] = this.availableLibraries[i].getName();
                ++i;
            }
            this.runtimeCombo.setItems(items);
            int initialIndex = 0;
            if (this.currentEntry != null) {
                IPath currPath = this.currentEntry.getPath();
                int i2 = 0;
                while (i2 < this.availableLibraries.length) {
                    if (this.availableLibraries[i2].getPath().equals((Object)currPath)) {
                        initialIndex = i2;
                        break;
                    }
                    ++i2;
                }
            }
            this.runtimeCombo.select(initialIndex);
            this.selectionChanged();
        }
        this.setControl((Control)composite);
    }

    private void selectionChanged() {
        int idx = this.runtimeCombo.getSelectionIndex();
        if (idx < 0 || idx >= this.availableLibraries.length) {
            return;
        }
        EDTRuntimeContainer container = this.availableLibraries[idx];
        this.description.setText(container.getDescription());
        StringBuilder buf = new StringBuilder();
        EDTRuntimeContainerEntry[] entries = container.getEntries();
        if (entries != null && entries.length > 0) {
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getClasspathEntry() != null) {
                    if (buf.length() > 0) {
                        buf.append("\n");
                    }
                    buf.append(entries[i].getClasspathEntry().getPath());
                }
                ++i;
            }
        }
        this.path.setText(buf.toString());
        this.currentEntry = JavaCore.newContainerEntry((IPath)container.getPath());
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.setPageComplete(this.runtimeCombo != null && this.runtimeCombo.getItemCount() > 0);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.currentEntry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.currentEntry = containerEntry;
    }
}

