/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.viewsupport;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRootContainer;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class EGLElementLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_EXCEPTIONS = 4;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_FULLY_QUALIFIED = 128;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int D_QUALIFIED = 65536;
    public static final int D_POST_QUALIFIED = 131072;
    public static final int CF_QUALIFIED = 262144;
    public static final int CF_POST_QUALIFIED = 524288;
    public static final int CU_QUALIFIED = 0x100000;
    public static final int CU_POST_QUALIFIED = 0x200000;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final int ALL_FULLY_QUALIFIED = 39135392;
    public static final int ALL_POST_QUALIFIED = 78287168;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 1386656;
    public static final int DEFAULT_POST_QUALIFIED = 2789696;
    public static final String CONCAT_STRING = NewWizardMessages.EGLElementLabels_concat_string;
    public static final String COMMA_STRING = NewWizardMessages.EGLElementLabels_comma_string;
    public static final String DECL_STRING = NewWizardMessages.EGLElementLabels_declseparator_string;
    private static String fgPkgNamePattern = "";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;

    static {
        fgPkgNameLength = -1;
    }

    private EGLElementLabels() {
    }

    public static String getTextLabel(Object obj, int flags) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof IEGLElement) {
            return EGLElementLabels.getElementLabel((IEGLElement)obj, flags);
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbadapter.getLabel(obj);
        }
        return "";
    }

    public static String getElementLabel(IEGLElement element, int flags) {
        StringBuffer buf = new StringBuffer(60);
        EGLElementLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(IEGLElement element, int flags, StringBuffer buf) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = EGLModelUtil.getPackageFragmentRoot((IEGLElement)element);
        }
        if (root != null && EGLElementLabels.getFlag(flags, 0x10000000)) {
            EGLElementLabels.getPackageFragmentRootLabel(root, 0x2000000, buf);
            buf.append(CONCAT_STRING);
        }
        switch (type) {
            case 6: {
                EGLElementLabels.getEGLFileLabel((IEGLFile)element, flags, buf);
                break;
            }
            case 4: {
                EGLElementLabels.getPackageFragmentLabel((IPackageFragment)element, flags, buf);
                break;
            }
            case 3: {
                EGLElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)element, flags, buf);
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 14: {
                buf.append(element.getElementName());
                break;
            }
            default: {
                buf.append(element.getElementName());
            }
        }
    }

    public static void getEGLFileLabel(IEGLFile eglFile, int flags, StringBuffer buf) {
        IPackageFragment pack;
        if (EGLElementLabels.getFlag(flags, 262144) && !(pack = (IPackageFragment)eglFile.getParent()).isDefaultPackage()) {
            buf.append(pack.getElementName());
            buf.append('.');
        }
        buf.append(eglFile.getElementName());
        if (EGLElementLabels.getFlag(flags, 524288)) {
            buf.append(CONCAT_STRING);
            EGLElementLabels.getPackageFragmentLabel((IPackageFragment)eglFile.getParent(), 0, buf);
        }
    }

    public static void getPackageFragmentLabel(IPackageFragment pack, int flags, StringBuffer buf) {
        if (EGLElementLabels.getFlag(flags, 0x400000)) {
            EGLElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x2000000, buf);
            buf.append('/');
        }
        EGLElementLabels.refreshPackageNamePattern();
        if (pack.isDefaultPackage()) {
            buf.append(NewWizardMessages.NewElementWizardDefaultpackageLabel);
        } else if (EGLElementLabels.getFlag(flags, 0x20000000) && fgPkgNameLength >= 0) {
            String name = pack.getElementName();
            int start = 0;
            int dot = name.indexOf(46, start);
            while (dot > 0) {
                if (dot - start > fgPkgNameLength - 1) {
                    buf.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        buf.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                    }
                    buf.append(fgPkgNamePostfix);
                } else {
                    buf.append(name.substring(start, dot + 1));
                }
                start = dot + 1;
                dot = name.indexOf(46, start);
            }
            buf.append(name.substring(start));
        } else {
            buf.append(pack.getElementName());
        }
        if (EGLElementLabels.getFlag(flags, 0x800000)) {
            buf.append(CONCAT_STRING);
            EGLElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x2000000, buf);
        }
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        EGLElementLabels.getFolderLabel(root, flags, buf);
    }

    private static void refreshPackageNamePattern() {
        String pattern = EGLElementLabels.getPkgNamePatternForPackagesView();
        if (pattern.equals(fgPkgNamePattern)) {
            return;
        }
        if (pattern.equals("")) {
            fgPkgNamePattern = "";
            fgPkgNameLength = -1;
            return;
        }
        fgPkgNamePattern = pattern;
        int i = 0;
        fgPkgNameChars = 0;
        fgPkgNamePrefix = "";
        fgPkgNamePostfix = "";
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (Character.isDigit(ch)) {
                fgPkgNameChars = ch - 48;
                if (i > 0) {
                    fgPkgNamePrefix = pattern.substring(0, i);
                }
                if (i >= 0) {
                    fgPkgNamePostfix = pattern.substring(i + 1);
                }
                fgPkgNameLength = fgPkgNamePrefix.length() + fgPkgNameChars + fgPkgNamePostfix.length();
                return;
            }
            ++i;
        }
        fgPkgNamePrefix = pattern;
        fgPkgNameLength = pattern.length();
    }

    private static void getFolderLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = EGLElementLabels.getFlag(flags, 0x2000000);
        boolean bl = referencedQualified = EGLElementLabels.getFlag(flags, 0x40000000) && EGLModelUtil.isReferenced((IPackageFragmentRoot)root) && resource != null;
        if (rootQualified) {
            buf.append(root.getPath().makeRelative().toString());
        } else {
            if (resource != null) {
                buf.append(resource.getProjectRelativePath().toString());
            } else if (root instanceof EglarPackageFragmentRootContainer) {
                buf.append(((EglarPackageFragmentRootContainer)root).getLabel());
            } else if (root instanceof EglarPackageFragmentRoot) {
                buf.append(root.getElementName());
                buf.append(CONCAT_STRING);
                buf.append(root.getPath().removeLastSegments(1).toOSString());
            } else {
                buf.append(root.getElementName());
            }
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getProject().getName());
            } else if (EGLElementLabels.getFlag(flags, 0x4000000)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getElementName());
            }
        }
    }

    private static boolean getFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    private static String getPkgNamePatternForPackagesView() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (!store.getBoolean("org.eclipse.jdt.ui.compresspackagenames")) {
            return "";
        }
        return store.getString("PackagesView.pkgNamePatternForPackagesView");
    }
}

