/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.refactoring.participants.ResourceModifications;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.RefactoringModifications;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class CopyModifications
extends RefactoringModifications {
    private List fCopies = new ArrayList();
    private List fCopyArguments = new ArrayList();
    private List fParticipantDescriptorFilter = new ArrayList();

    public void copy(IResource resource, CopyArguments args) {
        this.add(resource, (RefactoringArguments)args, null);
    }

    public void copy(IEGLElement element, CopyArguments eglArgs, CopyArguments resourceArgs) throws CoreException {
        switch (element.getElementType()) {
            case 3: {
                this.copy((IPackageFragmentRoot)element, eglArgs, resourceArgs);
                break;
            }
            case 4: {
                this.copy((IPackageFragmentRoot)element, eglArgs, resourceArgs);
                break;
            }
            case 6: {
                this.copy((IEGLFile)element, eglArgs, resourceArgs);
                break;
            }
            default: {
                this.add(element, (RefactoringArguments)eglArgs, null);
            }
        }
    }

    public void copy(IPackageFragmentRoot sourceFolder, CopyArguments eglArgs, CopyArguments resourceArgs) {
        this.add(sourceFolder, (RefactoringArguments)eglArgs, null);
        this.add(sourceFolder.getResource(), (RefactoringArguments)resourceArgs, null);
        IResource sourceResource = sourceFolder.getResource();
        if (sourceResource != null) {
            this.getResourceModifications().addCopyDelta(sourceResource, resourceArgs);
            IFile classpath = this.getEGLPathFile((IResource)resourceArgs.getDestination());
            if (classpath != null) {
                this.getResourceModifications().addChanged(classpath);
            }
        }
    }

    public void copy(IPackageFragment pack, CopyArguments eglArgs, CopyArguments resourceArgs) throws CoreException {
        this.add(pack, (RefactoringArguments)eglArgs, null);
        this.add(pack.getResource(), (RefactoringArguments)resourceArgs, null);
        IPackageFragmentRoot eglDestination = (IPackageFragmentRoot)eglArgs.getDestination();
        if (eglDestination.getResource() == null) {
            return;
        }
        IPackageFragment newPack = eglDestination.getPackageFragment(pack.getElementName());
        if (!(pack.hasSubpackages() || newPack.exists() && !pack.equals(newPack))) {
            IContainer resourceDestination = newPack.getResource().getParent();
            this.createIncludingParents(resourceDestination);
            this.getResourceModifications().addCopyDelta(pack.getResource(), resourceArgs);
        } else {
            IContainer resourceDestination = (IContainer)newPack.getResource();
            this.createIncludingParents(resourceDestination);
            CopyArguments arguments = new CopyArguments((Object)resourceDestination, resourceArgs.getExecutionLog());
            IResource[] resourcesToCopy = this.collectResourcesOfInterest(pack);
            int i = 0;
            while (i < resourcesToCopy.length) {
                IResource toCopy = resourcesToCopy[i];
                this.getResourceModifications().addCopyDelta(toCopy, arguments);
                ++i;
            }
        }
    }

    public void copy(IEGLFile unit, CopyArguments eglArgs, CopyArguments resourceArgs) throws CoreException {
        this.add(unit, (RefactoringArguments)eglArgs, null);
        this.add(unit.getResource(), (RefactoringArguments)resourceArgs, null);
        if (unit.getResource() != null) {
            this.getResourceModifications().addCopyDelta(unit.getResource(), resourceArgs);
        }
    }

    @Override
    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        int i = 0;
        while (i < this.fCopies.size()) {
            Object element = this.fCopies.get(i);
            if (element instanceof IResource) {
                ResourceModifications.buildCopyDelta(builder, (IResource)element, (CopyArguments)this.fCopyArguments.get(i));
            }
            ++i;
        }
        this.getResourceModifications().buildDelta(builder);
    }

    @Override
    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.fCopies.size()) {
            result.addAll(Arrays.asList(ParticipantManager.loadCopyParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, this.fCopies.get(i), (CopyArguments)((CopyArguments)this.fCopyArguments.get(i)), (IParticipantDescriptorFilter)((IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(i)), (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void add(Object element, RefactoringArguments args, IParticipantDescriptorFilter filter) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)args);
        this.fCopies.add(element);
        this.fCopyArguments.add(args);
        this.fParticipantDescriptorFilter.add(filter);
    }
}

