/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLIOStatementUtility;
import org.eclipse.edt.ide.ui.internal.quickfix.AssistContext;
import org.eclipse.edt.ide.ui.internal.quickfix.CorrectionMessages;
import org.eclipse.edt.ide.ui.internal.quickfix.IInvocationContext;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.AbstractSQLStatementProposal;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql.EGLSQLDeclareStatementFactory;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql.EGLSQLStatementFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;

public class SQLStatementAddAssistProposal
extends AbstractSQLStatementProposal {
    private IInvocationContext fContext;

    SQLStatementAddAssistProposal(String label, IEGLFile eglFile, int relevance, Image image, IEGLDocument document) {
        super(label, eglFile, relevance, image, document);
    }

    public SQLStatementAddAssistProposal(String label, int relevance, Image image, IInvocationContext context) {
        super(label, context.getEGLFile(), relevance, image, context.getDocument());
        this.fContext = context;
        if (this.fContext instanceof AssistContext) {
            this.editor = (EGLEditor)((AssistContext)this.fContext).getEditor();
        }
    }

    @Override
    protected ASTRewrite getRewrite() {
        try {
            final ASTRewrite rewrite = ASTRewrite.create((File)this.fContext.getFileAST());
            AbstractSQLStatementProposal.IBoundNodeProcessor processor = new AbstractSQLStatementProposal.IBoundNodeProcessor(){

                @Override
                public void processBoundNode(Node boundNode, Node containerNode) {
                    if (!(boundNode instanceof Statement)) {
                        return;
                    }
                    Statement sqlNode = AbstractSQLStatementProposal.SQLStatementFinder(SQLStatementAddAssistProposal.this.fContext);
                    IEGLDocument document = SQLStatementAddAssistProposal.this.fContext.getDocument();
                    SQLStatementAddAssistProposal.this.info = SQLIOStatementUtility.getAddSQLIoStatementActionInfo(document, boundNode);
                    SQLStatementAddAssistProposal.this.initialize();
                    if (!SQLStatementAddAssistProposal.this.isEGLStatementValidForAction()) {
                        SQLStatementAddAssistProposal.this.sqlStatement = null;
                    }
                    SQLStatementAddAssistProposal.this.createDefault(SQLStatementAddAssistProposal.this.info.getStatement());
                    if (SQLStatementAddAssistProposal.this.info.getSqlStatementNode() == null && sqlNode instanceof OpenStatement) {
                        OpenStatement openStatement = (OpenStatement)sqlNode;
                        ForExpressionClause nodeToRemove = null;
                        List openTargets = openStatement.getOpenTargets();
                        if (openTargets != null) {
                            for (Object target : openTargets) {
                                if (!(target instanceof ForExpressionClause)) continue;
                                nodeToRemove = (ForExpressionClause)target;
                                break;
                            }
                        }
                        if (nodeToRemove != null) {
                            rewrite.removeNode(nodeToRemove);
                        }
                    }
                    if (SQLStatementAddAssistProposal.this.sqlStatement != null) {
                        rewrite.completeIOStatement(sqlNode, SQLStatementAddAssistProposal.this.getStatementText());
                    } else {
                        SQLStatementAddAssistProposal.this.sqlStatement = " " + CorrectionMessages.SQLExceptionMessage;
                        rewrite.completeIOStatement(sqlNode, SQLStatementAddAssistProposal.this.sqlStatement);
                    }
                }
            };
            this.bindASTNode(this.fContext, processor);
            return rewrite;
        }
        catch (Exception e) {
            EDTUIPlugin.log((IStatus)new Status(4, "org.eclipse.edt.ide.ui", "Complete function: Error complete function", (Throwable)e));
            return null;
        }
    }

    public void bindASTNode(IInvocationContext context, AbstractSQLStatementProposal.IBoundNodeProcessor processor) {
        Statement sqlNode = AbstractSQLStatementProposal.SQLStatementFinder(context);
        IEGLDocument document = context.getDocument();
        if (sqlNode != null) {
            IFileEditorInput fileInput = (IFileEditorInput)this.editor.getEditorInput();
            this.bindASTNode(document, null, sqlNode.getOffset(), fileInput.getFile(), processor);
        }
    }

    protected void createDefault(Statement statement) {
        EGLSQLStatementFactory statementFactory = this.createSQLStatementFactory(statement);
        this.sqlStatement = null;
        if (statementFactory != null) {
            this.sqlStatement = statementFactory.buildDefaultSQLStatement();
            if (!this.info.isUsingExisted()) {
                this.usingClause = statementFactory.getEglUsingClause();
            }
            if (this.isGetByPositionStatement()) {
                this.sqlStatement = null;
            }
            if (this.isAddIntoClause() && statementFactory instanceof EGLSQLDeclareStatementFactory) {
                this.intoClause = ((EGLSQLDeclareStatementFactory)statementFactory).getIntoClause();
            }
            this.getMessages().addAll(statementFactory.getErrorMessages());
        }
    }

    protected boolean isEGLStatementValidForAction() {
        boolean isValid = true;
        isValid = this.hasEGLSQLStatementErrors();
        if (isValid) {
            this.ensureSQLStatementIsNotCloseOrDelete();
            if (!this.ensureExplicitSQLStatementAllowed()) {
                return false;
            }
            if (this.info.getActionToRun() == null) {
                if (this.ensureSQLRecordVariableIsSpecified()) {
                    this.info.setSqlRecordBinding(this.getSQLRecordBindingFromTarget());
                } else {
                    isValid = false;
                }
            }
            if (this.isSQLRecordVariableSpecified() && !this.ensureDynamicArrayAllowed()) {
                return false;
            }
            if (!this.ensureSQLStatementIsNotSpecified()) {
                isValid = false;
            }
            if (!this.ensurePreparedStatementReferenceIsNotSpecified()) {
                isValid = false;
            }
        }
        return isValid;
    }
}

