/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.Strings;
import org.eclipse.edt.ide.ui.internal.quickfix.CorrectionMessages;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.ChangeCorrectionProposal;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.EGLFileChange;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.edt.ide.ui.internal.util.Resources;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class EGLFileCorrectionProposal
extends ChangeCorrectionProposal {
    private IEGLFile fEGLFile;
    private IEGLDocument fDocument;
    private final int surroundLines = 1;

    public EGLFileCorrectionProposal(String name, IEGLFile eglFile, TextChange change, int relevance, Image image, IEGLDocument document) {
        super(name, (Change)change, relevance, image);
        if (eglFile == null) {
            throw new IllegalArgumentException("EGL File must not be null");
        }
        this.fEGLFile = eglFile;
        this.fDocument = document;
    }

    protected EGLFileCorrectionProposal(String name, IEGLFile eglFile, int relevance, Image image, IEGLDocument document) {
        this(name, eglFile, null, relevance, image, document);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    @Override
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuffer buf = new StringBuffer();
        try {
            TextChange change = this.getTextChange();
            change.setKeepPreviewEdits(true);
            IDocument doc = null;
            try {
                doc = change.getPreviewDocument(monitor);
            }
            catch (Exception exception) {
                doc = null;
            }
            Object previewContent = doc != null ? doc : this.fDocument;
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            class EditAnnotator
            extends TextEditVisitor {
                private int fWrittenToPos = 0;
                private final /* synthetic */ IDocument val$previewContent;
                private final /* synthetic */ StringBuffer val$buf;

                EditAnnotator(IDocument iDocument, StringBuffer stringBuffer) {
                    this.val$previewContent = iDocument;
                    this.val$buf = stringBuffer;
                }

                public void unchangedUntil(int pos) {
                    if (pos > this.fWrittenToPos) {
                        EGLFileCorrectionProposal.this.appendContent(this.val$previewContent, this.fWrittenToPos, pos, this.val$buf, true);
                        this.fWrittenToPos = pos;
                    }
                }

                public boolean visit(MoveTargetEdit edit) {
                    return true;
                }

                public boolean visit(CopyTargetEdit edit) {
                    return true;
                }

                public boolean visit(InsertEdit edit) {
                    return this.rangeAdded((TextEdit)edit, edit.getText());
                }

                public boolean visit(ReplaceEdit edit) {
                    if (edit.getLength() > 0) {
                        return this.rangeAdded((TextEdit)edit, edit.getText());
                    }
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(MoveSourceEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(DeleteEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                private boolean rangeRemoved(TextEdit edit) {
                    this.unchangedUntil(edit.getOffset());
                    return false;
                }

                private boolean rangeAdded(TextEdit edit, String text) {
                    this.unchangedUntil(edit.getOffset());
                    this.val$buf.append("<b>");
                    this.val$buf.append(text.replace(TextUtilities.getDefaultLineDelimiter((IDocument)EGLFileCorrectionProposal.this.fDocument), "<br>"));
                    this.val$buf.append("</b>");
                    this.fWrittenToPos = edit.getExclusiveEnd();
                    return false;
                }
            }
            EditAnnotator ea = new EditAnnotator((IDocument)previewContent, buf);
            rootEdit.accept((TextEditVisitor)ea);
            ea.unchangedUntil(previewContent.getLength());
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
        }
        return buf.toString();
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) {
        try {
            int startLine = text.getLineOfOffset(startOffset);
            int endLine = text.getLineOfOffset(endOffset);
            boolean dotsAdded = false;
            if (surroundLinesOnly && startOffset == 0) {
                startLine = Math.max(endLine - 1, 0);
                buf.append("...<br>");
                dotsAdded = true;
            }
            int i = startLine;
            while (i <= endLine) {
                if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                    if (!dotsAdded) {
                        buf.append("...<br>");
                        dotsAdded = true;
                    } else if (endOffset == text.getLength()) {
                        return;
                    }
                } else {
                    IRegion lineInfo = text.getLineInformation(i);
                    int start = lineInfo.getOffset();
                    int end = start + lineInfo.getLength();
                    int from = Math.max(start, startOffset);
                    int to = Math.min(end, endOffset);
                    String content = text.get(from, to - from);
                    if (!surroundLinesOnly || from != start || !Strings.containsOnlyWhitespaces(content)) {
                        int k = 0;
                        while (k < content.length()) {
                            char ch = content.charAt(k);
                            if (ch == '<') {
                                buf.append("&lt;");
                            } else if (ch == '>') {
                                buf.append("&gt;");
                            } else {
                                buf.append(ch);
                            }
                            ++k;
                        }
                        if (to == end && to != endOffset) {
                            buf.append("<br>");
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    public void apply(IDocument document) {
        try {
            IEGLFile eglFile = this.getEGLFile();
            IEditorPart part = null;
            if (eglFile.getResource().exists()) {
                IWorkbenchPage page;
                boolean canEdit = this.performValidateEdit(eglFile);
                if (!canEdit) {
                    return;
                }
                part = EditorUtility.isOpenInEditor(eglFile);
                if (part == null && (part = EGLUI.openInEditor((IEGLElement)eglFile)) != null) {
                    document = EGLUI.getDocumentProvider().getDocument((Object)part.getEditorInput());
                }
                if ((page = EDTUIPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    part.setFocus();
                }
            }
            this.performChange(part, document);
        }
        catch (CoreException coreException) {}
    }

    private boolean performValidateEdit(IEGLFile eglFile) {
        IStatus status = Resources.makeCommittable(eglFile.getResource(), (Object)EDTUIPlugin.getActiveWorkbenchShell());
        if (!status.isOK()) {
            String label = CorrectionMessages.EGLCorrectionProposal_error_title;
            String message = CorrectionMessages.EGLCorrectionProposal_error_message;
            ErrorDialog.openError((Shell)EDTUIPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
            return false;
        }
        return true;
    }

    @Override
    protected void performChange(IEditorPart part, IDocument document) throws CoreException {
        super.performChange(part, document);
    }

    protected TextChange createTextChange() throws CoreException {
        EGLFileChange change;
        Document document;
        IEGLFile eglFile = this.getEGLFile();
        String name = this.getName();
        if (!eglFile.getResource().exists()) {
            String source;
            try {
                source = eglFile.getSource();
            }
            catch (EGLModelException e) {
                EDTUIPlugin.log(e);
                source = new String();
            }
            document = new Document(source);
            document.setInitialLineDelimiter(TextUtilities.getDefaultLineDelimiter((IDocument)document));
            change = new DocumentChange(name, (IDocument)document);
        } else {
            EGLFileChange eglChange = new EGLFileChange(name, eglFile);
            eglChange.setSaveMode(4);
            change = eglChange;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)rootEdit);
        return change;
    }

    @Override
    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final IEGLFile getEGLFile() {
        return this.fEGLFile;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }
}

