/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.deployment.ui.FileBrowseDialog;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class DefaultDeploymentDescriptorComposite
extends Composite {
    protected static final int INDENT_SIZE = 20;
    private Button specifyValueButton;
    private DDSettings defaultDDSettings;
    private IProject containingProject = null;

    public DefaultDeploymentDescriptorComposite(Composite parent, int style, IResource resource) {
        super(parent, style);
        if (resource != null) {
            this.containingProject = resource.getProject();
        }
        this.createContentArea(this);
    }

    private void createContentArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        this.createCompositeSection(layout.numColumns);
    }

    protected void createCompositeSection(int numColumns) {
        this.defaultDDSettings = new DDSettings(this, this.containingProject);
    }

    protected void doCreateCompositeSection(int numColumns) {
        this.specifyValueButton = new Button((Composite)this, 16);
        this.specifyValueButton.setText(UINlsStrings.DefaultDDPropertiesPageSpecifyValuesLabel);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        gd.horizontalIndent = 10;
        this.specifyValueButton.setLayoutData((Object)gd);
    }

    public DDSettings getDefaultDDSettings() {
        return this.defaultDDSettings;
    }

    public static class DDSettings {
        protected Text bdText;
        protected Button browseBtn;
        protected Button clearBtn;
        private PartWrapper initialDD;
        private PartWrapper currentDD;
        private boolean hasValueSet;
        private final Shell shell;

        public DDSettings(Composite parent, final IProject resource) {
            this.shell = parent.getShell();
            this.bdText = new Text(parent, 2056);
            GridData gd = new GridData(768);
            this.bdText.setLayoutData((Object)gd);
            final String dialogLabel = UINlsStrings.DefaultDDPropertiesPageBrowseDialogRuntimeJavaScriptDesc;
            this.browseBtn = new Button(parent, 8);
            this.browseBtn.setText(UINlsStrings.DefaultDDPropertiesPageBrowseButtonLabel);
            this.browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DDSettings.this.clickBrowseButton(DDSettings.this.browseBtn, DDSettings.this.bdText, dialogLabel, resource);
                }
            });
            this.clearBtn = new Button(parent, 8);
            this.clearBtn.setText(UINlsStrings.DefaultDDPropertiesPageClearButtonLabel);
            this.clearBtn.setEnabled(false);
            this.clearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PartWrapper wrapper = new PartWrapper();
                    wrapper.setPartName("");
                    wrapper.setPartPath("");
                    DDSettings.this.setCurrentBD(wrapper);
                }
            });
        }

        protected void clickBrowseButton(Button button, Text text, String dialogDescription, IProject resource) {
            Object obj;
            ElementTreeSelectionDialog dialog;
            IResource r;
            IFile initialSelection = null;
            if (this.currentDD != null && this.currentDD.getPartPath() != null && (r = ResourcesPlugin.getWorkspace().getRoot().findMember(this.currentDD.getPartPath())) != null && r.getType() == 1) {
                initialSelection = (IFile)r;
            }
            if ((dialog = FileBrowseDialog.openBrowseFileOnEGLPathDialog(this.shell, resource, initialSelection, IUIHelpConstants.EGLDDWIZ_INCLUDEEGLDD, "egldd", SOAMessages.DefaultDeploymentDescription, SOAMessages.IncludeDialogDescription, SOAMessages.IncludeDialogMsg, null, null)).open() == 0 && (obj = dialog.getFirstResult()) instanceof IFile) {
                IPath path = ((IFile)obj).getFullPath();
                PartWrapper wrapper = new PartWrapper();
                wrapper.setPartName(path.removeFileExtension().lastSegment());
                wrapper.setPartPath(path.toString());
                this.setCurrentBD(wrapper);
            }
        }

        protected void setDDText(String bdName, String bdFile) {
            String value;
            if (bdName == null) {
                bdName = "";
            }
            if (bdFile == null) {
                bdFile = "";
            }
            if (bdFile.length() == 0) {
                value = UINlsStrings.DefaultBDPropertiesPageNoValueSetText;
                this.hasValueSet = false;
                this.updateClearButton();
            } else {
                value = String.valueOf(bdName) + " <" + bdFile + ">";
                this.hasValueSet = true;
                this.updateClearButton();
            }
            this.bdText.setText(value);
            this.bdText.setToolTipText(value);
        }

        protected void updateClearButton() {
            if (this.hasValueSet) {
                this.clearBtn.setEnabled(true);
            } else {
                this.clearBtn.setEnabled(false);
            }
        }

        public boolean isModified() {
            return !this.currentDD.equals(this.initialDD);
        }

        public PartWrapper getCurrentDD() {
            return this.currentDD;
        }

        public void setInitialDD(PartWrapper wrapper) {
            if (wrapper == null) {
                wrapper = new PartWrapper();
                wrapper.setPartName("");
                wrapper.setPartPath("");
            }
            this.initialDD = wrapper;
            this.setCurrentBD(wrapper);
        }

        private void setCurrentBD(PartWrapper wrapper) {
            this.currentDD = wrapper;
            this.setDDText(this.currentDD.getPartName(), this.currentDD.getPartPath());
        }

        public boolean hasValueSet() {
            return this.hasValueSet;
        }
    }
}

