/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.RenameDialog;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.SelectionListenerAction;

public class RenameAction
extends SelectionListenerAction
implements IActionDelegate {
    private IStructuredSelection renameSelection;

    public RenameAction() {
        super(UINlsStrings.Rename);
        this.updateSelection(this.getStructuredSelection());
    }

    public void run() {
        RenameDialog renameDialog;
        String elementType = "";
        IEGLElement EGLSelection = null;
        if (this.renameSelection.getFirstElement() instanceof IEGLElement) {
            EGLSelection = (IEGLElement)this.renameSelection.getFirstElement();
        }
        if (EGLSelection != null) {
            switch (EGLSelection.getElementType()) {
                case 6: {
                    elementType = NewWizardMessages.EGLRenameDialogElementTypeEGLFile;
                    break;
                }
                case 4: {
                    elementType = NewWizardMessages.EGLRenameDialogElementTypeEGLPackage;
                    break;
                }
                case 3: {
                    elementType = NewWizardMessages.EGLRenameDialogElementTypeEGLSourceFolder;
                    break;
                }
                default: {
                    elementType = NewWizardMessages.EGLRenameDialogElementTypeResource;
                    break;
                }
            }
        } else {
            elementType = NewWizardMessages.EGLRenameDialogElementTypeResource;
        }
        if ((renameDialog = new RenameDialog(new Shell(EDTUIPlugin.getActiveWorkbenchShell()), NewWizardMessages.bind((String)NewWizardMessages.EGLRenameDialogAction, (Object)elementType), NewWizardMessages.bind((String)NewWizardMessages.EGLRenameDialogMessage, (Object)elementType), RenameDialog.getInitElementNameToShow(EGLSelection), EGLSelection)).open() == 0) {
            switch (((IEGLElement)this.renameSelection.getFirstElement()).getElementType()) {
                case 6: {
                    IEGLFile renameFile = (IEGLFile)this.renameSelection.getFirstElement();
                    try {
                        renameFile.rename(String.valueOf(renameDialog.getValue()) + ".egl", true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (EGLModelException eGLModelException) {}
                    break;
                }
                case 4: {
                    IPackageFragment renamePackage = (IPackageFragment)this.renameSelection.getFirstElement();
                    try {
                        renamePackage.rename(renameDialog.getValue(), true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (EGLModelException eGLModelException) {}
                    break;
                }
                case 3: {
                    IPackageFragmentRoot renameSourceFolder = (IPackageFragmentRoot)this.renameSelection.getFirstElement();
                    try {
                        if (EGLSelection == null) break;
                        IPath destinationPath = EGLSelection.getPath().removeLastSegments(1).append(renameDialog.getValue());
                        renameSourceFolder.move(destinationPath, 0, 0, null, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    catch (EGLModelException eGLModelException) {}
                }
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.renameSelection = selection;
        if (selection.size() > 1) {
            return false;
        }
        Object element = this.renameSelection.getFirstElement();
        if (element instanceof IEGLElement) {
            IPackageFragment pkg;
            if (element instanceof IEGLFile) {
                return false;
            }
            return !(element instanceof IPackageFragment) || !(pkg = (IPackageFragment)element).isDefaultPackage();
        }
        return false;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = this.updateSelection((IStructuredSelection)selection);
        action.setEnabled(enable);
    }
}

