/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRootContainer;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.ui.internal.viewsupport.EGLElementLabels;
import org.eclipse.edt.ide.ui.internal.viewsupport.ElementImageProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class EGLElementLabelProvider
extends LabelProvider
implements ICommonLabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    public static final int SHOW_CONTAINER = 4;
    public static final int SHOW_CONTAINER_QUALIFICATION = 8;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_TYPE = 32;
    public static final int SHOW_ROOT = 64;
    public static final int SHOW_POSTIFIX_QUALIFICATION = 128;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_VARIABLE = 512;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    public ElementImageProvider fImageLabelProvider = new ElementImageProvider();
    private int fFlags;
    private int fImageFlags;
    private int fTextFlags;

    public EGLElementLabelProvider() {
    }

    public EGLElementLabelProvider(int flags) {
        this.fFlags = flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    public Image getImage(Object element) {
        Image result;
        this.fImageFlags = 0;
        IResource eglResource = null;
        IMarker[] eglMarkers = null;
        int searchDepth = 2;
        try {
            if (!(element instanceof EglarPackageFragmentRootContainer)) {
                String fileExtension;
                if (element instanceof IEGLProject || element instanceof IEGLElement) {
                    IEGLElement eglElement = (IEGLElement)element;
                    eglResource = eglElement.getUnderlyingResource();
                    if (eglElement instanceof IPackageFragment && ((IPackageFragment)eglElement).isDefaultPackage()) {
                        searchDepth = 1;
                    }
                } else if (element instanceof IProject && ((IProject)element).hasNature(EGLCore.NATURE_ID)) {
                    eglResource = (IProject)element;
                } else if (element instanceof IFile && (fileExtension = ((IFile)element).getFileExtension()) != null && "eglbld".equals(fileExtension.toLowerCase())) {
                    eglResource = (IFile)element;
                }
            }
            if (eglResource != null && (eglMarkers = eglResource.findMarkers("org.eclipse.core.resources.marker", true, searchDepth)).length > 0) {
                boolean foundError = false;
                int markerIndex = 0;
                while (markerIndex < eglMarkers.length) {
                    switch (eglMarkers[markerIndex].getAttribute("severity", 0)) {
                        case 2: {
                            foundError = true;
                            this.fImageFlags = 64;
                            break;
                        }
                        case 1: {
                            if (foundError) break;
                            this.fImageFlags = 32;
                        }
                    }
                    ++markerIndex;
                }
            }
        }
        catch (CoreException coreException) {}
        if ((result = this.fImageLabelProvider.getImageLabel(element, this.fImageFlags)) != null) {
            return result;
        }
        return result;
    }

    public String getText(Object element) {
        String text = EGLElementLabels.getTextLabel(element, 0);
        if (text.length() > 0) {
            return text;
        }
        return text;
    }

    private boolean getFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    private void updateImageProviderFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
    }

    private void updateTextProviderFlags() {
        this.fTextFlags = 0;
        if (this.getFlag(1)) {
            this.fTextFlags |= 8;
        }
        if (this.getFlag(2)) {
            this.fTextFlags |= 1;
        }
        if (this.getFlag(4)) {
            this.fTextFlags |= 0xA89040;
        }
        if (this.getFlag(128)) {
            this.fTextFlags |= 0x288000;
        } else if (this.getFlag(8)) {
            this.fTextFlags |= 0x142000;
        }
        if (this.getFlag(32)) {
            this.fTextFlags |= 0x200;
        }
        if (this.getFlag(64)) {
            this.fTextFlags |= 0x8000000;
        }
        if (this.getFlag(512)) {
            this.fTextFlags |= 0x1000000;
        }
        if (this.getFlag(1024)) {
            this.fTextFlags |= 0x1528A0;
        }
        if (this.getFlag(2048)) {
            this.fTextFlags |= 0x2A9140;
        }
    }

    public void initialize(String aViewerId) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

