/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLMarkerAnnotation;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ClassFileMarkerAnnotationModel
extends AbstractMarkerAnnotationModel
implements IResourceChangeListener {
    private final IResource resource;
    private final IClassFile classFile;

    public ClassFileMarkerAnnotationModel(IResource resource, IClassFile classFile) {
        this.resource = resource;
        this.classFile = classFile;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] rootMarkers = this.resource.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.marker", true, 0);
        IMarker[] resourceMarkers = this.resource.findMarkers("org.eclipse.core.resources.marker", true, 0);
        if (rootMarkers.length == 0) {
            return resourceMarkers;
        }
        if (resourceMarkers.length == 0) {
            return rootMarkers;
        }
        IMarker[] all = new IMarker[resourceMarkers.length + rootMarkers.length];
        System.arraycopy(resourceMarkers, 0, all, 0, resourceMarkers.length);
        System.arraycopy(rootMarkers, 0, all, resourceMarkers.length, rootMarkers.length);
        return all;
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.resource.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null, 1, null);
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        } else {
            this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    protected boolean isAcceptable(IMarker marker) {
        try {
            return EGLCore.isReferencedBy((IEGLElement)this.classFile, (IMarker)marker);
        }
        catch (CoreException ce) {
            EDTUIPlugin.log(ce);
            return false;
        }
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        return new EGLMarkerAnnotation(marker);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] deltas = event.findMarkerDeltas(null, true);
        if (deltas != null && deltas.length > 0) {
            boolean changed = false;
            IMarkerDelta[] iMarkerDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta delta = iMarkerDeltaArray[n2];
                try {
                    if (EGLCore.isReferencedBy((IEGLElement)this.classFile, (IMarkerDelta)delta)) {
                        switch (delta.getKind()) {
                            case 1: {
                                this.addMarkerAnnotation(delta.getMarker());
                                changed = true;
                                break;
                            }
                            case 2: {
                                this.removeMarkerAnnotation(delta.getMarker());
                                changed = true;
                                break;
                            }
                            case 4: {
                                this.modifyMarkerAnnotation(delta.getMarker());
                                changed = true;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (CoreException ce) {
                    EDTUIPlugin.log(ce);
                }
                ++n2;
            }
            if (changed) {
                this.fireModelChanged();
            }
        }
    }
}

