/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLVariableDotProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.jface.text.ITextViewer;

public class EGLVariableDotReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; handler a function a() var.");
        this.addContext("package a; handler a function a() (var).");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList result = new ArrayList();
        this.getBoundASTNode(viewer, documentOffset, new String[]{"x", "x;", "x=x;", "x);", "x to x;"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                final boolean[] isValid = new boolean[1];
                if (astNode != null) {
                    astNode.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(QualifiedName qualifiedName) {
                            isValid[0] = true;
                            return false;
                        }

                        public boolean visit(FieldAccess fieldAccess) {
                            isValid[0] = true;
                            return false;
                        }
                    });
                }
                return isValid[0];
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                boundNode.accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(QualifiedName qualifiedName) {
                        this.handleQualifier((Expression)qualifiedName.getQualifier());
                        return false;
                    }

                    public boolean visit(FieldAccess fieldAccess) {
                        this.handleQualifier(fieldAccess.getPrimary());
                        return false;
                    }

                    private void handleQualifier(Expression qualifier) {
                        Type tBinding = qualifier.resolveType();
                        boolean isVariable = qualifier.resolveMember() != null || EGLVariableDotReferenceCompletion.this.wantFieldsForType(qualifier) || (qualifier instanceof ThisExpression || qualifier instanceof SuperExpression) && !EGLVariableDotReferenceCompletion.this.inStaticFunction((Node)qualifier);
                        result.addAll(new EGLVariableDotProposalHandler(viewer, documentOffset, prefix, (this).EGLVariableDotReferenceCompletion.this.editor, tBinding, isVariable).getProposals(true));
                    }
                });
            }
        });
        return result;
    }

    private boolean inStaticFunction(Node node) {
        if (node == null) {
            return false;
        }
        if (node instanceof NestedFunction) {
            return ((NestedFunction)node).isStatic();
        }
        return this.inStaticFunction(node.getParent());
    }

    protected boolean wantFieldsForType(Expression expr) {
        final boolean[] result = new boolean[1];
        expr.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            public boolean visit(AsExpression asExpression) {
                result[0] = true;
                return false;
            }

            public boolean visit(FunctionInvocation fInvocation) {
                result[0] = true;
                return false;
            }
        });
        return result[0];
    }
}

