/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.services;

import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.gen.javascript.templates.eglx.services.CommonUtilities;
import org.eclipse.edt.gen.javascript.templates.eglx.services.Constants;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionInvocation;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionStatement;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NullLiteral;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.Environment;

public class FunctionTemplate
extends JavaScriptTemplate
implements Constants {
    public void genFunctionBody(Function function, Context ctx, TabbedWriter out) {
        function.getParameters().remove(function.getParameters().size() - 1);
        function.getParameters().remove(function.getParameters().size() - 1);
        function.getParameters().remove(function.getParameters().size() - 1);
        out.print("if(");
        out.print("ezeHttp");
        out.println(" == null){");
        if (function.getAnnotation("eglx.lang.Resource") != null) {
            Annotation annot = function.getAnnotation("eglx.lang.Resource");
            Field field = factory.createField();
            field.setName("ezeHttp");
            try {
                field.setType((Type)Environment.getCurrentEnv().find("egl:eglx.http.IHttp"));
            }
            catch (Exception exception) {}
            ctx.invoke("preGen", (EType)annot.getEClass(), new Object[]{ctx, annot, field});
            ctx.invoke("genStatementNoBraces", (EObject)field.getInitializerStatements(), new Object[]{ctx, out});
        } else {
            out.print("ezeHttp");
            out.println(" = null;");
        }
        out.println("}");
        Annotation rest = function.getAnnotation("eglx.rest.Rest");
        if (rest == null) {
            rest = function.getAnnotation("eglx.rest.EglService");
        }
        if (rest != null) {
            ctx.invoke("genRestInvocation", (EType)rest.getEClass(), new Object[]{ctx, out, rest, function});
        }
    }

    public void genDeclaration(Function function, Context ctx, TabbedWriter out) {
        Function proxyFunction = CommonUtilities.createProxyFunction(function, ctx);
        ctx.putAttribute((Object)proxyFunction, "realFunctionName", (Object)function.getCaseSensitiveName());
        ctx.invokeSuper((Template)this, "genDeclaration", (EObject)proxyFunction, new Object[]{ctx, out});
        ctx.remove((Object)proxyFunction);
        Function newFunction = this.createFunction(function, ctx);
        ctx.invoke("genFunction", (EObject)function.getContainer(), new Object[]{ctx, out, newFunction});
    }

    private Function createFunction(Function function, Context ctx) {
        Function newFunction = factory.createFunction();
        newFunction.setContainer(function.getContainer());
        if (function.getAnnotation("EGL_Location") != null) {
            newFunction.addAnnotation(function.getAnnotation("EGL_Location"));
        }
        newFunction.setName(function.getCaseSensitiveName());
        for (FunctionParameter parameter : function.getParameters()) {
            FunctionParameter newParameter = (FunctionParameter)parameter.clone();
            newParameter.setContainer((Container)newFunction);
            newFunction.addParameter(newParameter);
        }
        Statement stmt = this.createFunctionInvocationBody(newFunction, ctx);
        if (function.getAnnotation("EGL_Location") != null) {
            stmt.addAnnotation(function.getAnnotation("EGL_Location"));
        }
        newFunction.setStatementBlock(factory.createStatementBlock());
        newFunction.getStatementBlock().setContainer((Container)newFunction);
        newFunction.addStatement(stmt);
        return newFunction;
    }

    private Statement createFunctionInvocationBody(Function function, Context ctx) {
        FunctionInvocation invoc = factory.createFunctionInvocation();
        if (function.getAnnotation("EGL_Location") != null) {
            invoc.addAnnotation(function.getAnnotation("EGL_Location"));
        }
        Function proxy = CommonUtilities.createProxyFunction(function, ctx);
        proxy.setContainer(function.getContainer());
        invoc.setTarget((Member)proxy);
        invoc.setId(CommonUtilities.createProxyFunctionName(function));
        for (FunctionParameter parameter : function.getParameters()) {
            invoc.getArguments().add(CommonUtilities.createMember(parameter, ctx));
        }
        NullLiteral nullLit = factory.createNullLiteral();
        invoc.getArguments().add(nullLit);
        invoc.getArguments().add(nullLit);
        invoc.getArguments().add(nullLit);
        FunctionStatement functionStatement = factory.createFunctionStatement();
        functionStatement.setContainer((Container)function);
        functionStatement.setExpr((Expression)invoc);
        return functionStatement;
    }
}

