/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.SettingsBlockLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class EGLRUIWidgetUpdateStrategy {
    private File fileAST;
    private IEGLDocument currentDocument;
    private Handler handler;
    private int theCharactersAdded = 0;

    public EGLRUIWidgetUpdateStrategy(Handler handler, IEGLDocument document) {
        this.currentDocument = document;
        this.fileAST = this.currentDocument.getNewModelEGLFile();
        this.handler = handler;
    }

    public int insertTargetWidget(final String insertText) {
        SettingsBlockLocator locator = new SettingsBlockLocator();
        this.handler.accept((IASTVisitor)locator);
        if (locator.getSettingsBlock() != null) {
            locator.getSettingsBlock().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(SettingsBlock settingsBlock) {
                    try {
                        ASTRewrite rewrite = ASTRewrite.create((File)EGLRUIWidgetUpdateStrategy.this.fileAST);
                        String childrenString = "targetWidget = " + insertText;
                        if (settingsBlock.getSettings().size() > 0) {
                            Node firstNode = (Node)settingsBlock.getSettings().get(0);
                            String nodeText = EGLRUIWidgetUpdateStrategy.this.currentDocument.get(firstNode.getOffset(), settingsBlock.getLength() - (firstNode.getOffset() - settingsBlock.getOffset()));
                            childrenString = "{" + childrenString + ", " + nodeText;
                        } else {
                            childrenString = "{" + childrenString + "}";
                        }
                        rewrite.setText((Node)settingsBlock, childrenString);
                        rewrite.rewriteAST((IDocument)EGLRUIWidgetUpdateStrategy.this.currentDocument).apply((IDocument)EGLRUIWidgetUpdateStrategy.this.currentDocument);
                        EGLRUIWidgetUpdateStrategy.this.theCharactersAdded = childrenString.length();
                    }
                    catch (BadLocationException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error creating initialUI field", (Throwable)e));
                    }
                    return false;
                }
            });
        } else {
            try {
                ASTRewrite rewrite = ASTRewrite.create((File)this.fileAST);
                String subTypeText = this.currentDocument.get(this.handler.getSubType().getOffset(), this.handler.getSubType().getLength());
                String childrenString = String.valueOf(subTypeText) + " {targetWidget =  " + insertText + "}";
                rewrite.setText((Node)this.handler.getSubType(), childrenString);
                rewrite.rewriteAST((IDocument)this.currentDocument).apply((IDocument)this.currentDocument);
                this.theCharactersAdded = childrenString.length();
            }
            catch (BadLocationException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error creating settings block", (Throwable)e));
            }
        }
        return this.theCharactersAdded;
    }
}

