/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.SettingsBlockLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.BadLocationException;

public class EGLRUIHandlerDeleteStrategy {
    private int theCharactersRemoved = 0;
    private IEGLDocument currentDocument;
    private Handler handler;
    private String deletedWidgetName;

    public EGLRUIHandlerDeleteStrategy(Handler handler, IEGLDocument document) {
        this.currentDocument = document;
        this.handler = handler;
    }

    public int deleteFromHandler(final int index) {
        SettingsBlockLocator locator = new SettingsBlockLocator();
        this.handler.accept((IASTVisitor)locator);
        if (locator.getSettingsBlock() != null) {
            locator.getSettingsBlock().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(SettingsBlock settingsBlock) {
                    return true;
                }

                public boolean visit(Assignment assignment) {
                    try {
                        if (assignment.getLeftHandSide().isName() && NameUtile.equals((String)NameUtile.getAsName((String)"initialUI"), (String)((Name)assignment.getLeftHandSide()).getIdentifier())) {
                            assignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                                public boolean visit(ArrayLiteral arrayLiteral) {
                                    List expressions = arrayLiteral.getExpressions();
                                    Node referenceNode = (Node)expressions.get(index);
                                    int referenceOffset = referenceNode.getOffset();
                                    int referenceLength = referenceNode.getLength();
                                    try {
                                        EGLRUIHandlerDeleteStrategy.this.deletedWidgetName = EGLRUIHandlerDeleteStrategy.this.currentDocument.get(referenceOffset, referenceLength);
                                    }
                                    catch (BadLocationException e) {
                                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error deleting item from RUIHandler", (Throwable)e));
                                    }
                                    if (expressions.size() > 1) {
                                        if (index == expressions.size() - 1) {
                                            Node previousWidget = (Node)expressions.get(index - 1);
                                            try {
                                                EGLRUIHandlerDeleteStrategy.this.theCharactersRemoved = referenceOffset + referenceLength - (previousWidget.getOffset() + previousWidget.getLength());
                                                EGLRUIHandlerDeleteStrategy.this.currentDocument.replace(previousWidget.getOffset() + previousWidget.getLength(), EGLRUIHandlerDeleteStrategy.this.theCharactersRemoved, "");
                                            }
                                            catch (BadLocationException e) {
                                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error deleting last widget reference from RUIHandler", (Throwable)e));
                                            }
                                        } else {
                                            Node nextWidget = (Node)expressions.get(index + 1);
                                            try {
                                                String nextWidgetText = EGLRUIHandlerDeleteStrategy.this.currentDocument.get(referenceOffset, nextWidget.getOffset() + nextWidget.getLength() - referenceOffset);
                                                nextWidgetText = nextWidgetText.substring(nextWidgetText.indexOf(",", referenceLength) + 1, nextWidgetText.length()).trim();
                                                EGLRUIHandlerDeleteStrategy.this.theCharactersRemoved = nextWidget.getOffset() + nextWidget.getLength() - referenceOffset - nextWidgetText.length();
                                                EGLRUIHandlerDeleteStrategy.this.currentDocument.replace(referenceOffset, nextWidget.getOffset() + nextWidget.getLength() - referenceOffset, nextWidgetText);
                                            }
                                            catch (BadLocationException e) {
                                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error deleting item from RUIHandler", (Throwable)e));
                                            }
                                        }
                                    } else {
                                        try {
                                            EGLRUIHandlerDeleteStrategy.this.theCharactersRemoved = referenceLength;
                                            EGLRUIHandlerDeleteStrategy.this.currentDocument.replace(referenceOffset, referenceLength, "");
                                        }
                                        catch (BadLocationException e) {
                                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error deleting item from RUIHandler", (Throwable)e));
                                        }
                                    }
                                    return false;
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error deleting item from RUIhandler", (Throwable)e));
                    }
                    return false;
                }
            });
        }
        return this.theCharactersRemoved;
    }

    public String getDeletedWidgetName() {
        return this.deletedWidgetName;
    }
}

