/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.testserver.AbstractTestServerContribution;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TestServerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.edt.ide.testserver";
    private static TestServerPlugin plugin;
    public static final String TEST_SERVER_CONTRIBUTION_ID = "org.eclipse.edt.ide.testserver.testServerExtension";
    private static final Object syncObj;
    private static AbstractTestServerContribution[] contributions;
    private IPath tempDirectory;

    static {
        syncObj = new Object();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.tempDirectory = this.getStateLocation().append("jettyTemp");
        File tempDir = this.tempDirectory.toFile();
        if (tempDir.exists()) {
            this.delete(tempDir);
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.delete(f);
                ++n2;
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = syncObj;
        synchronized (object) {
            if (contributions != null) {
                AbstractTestServerContribution[] abstractTestServerContributionArray = contributions;
                int n = contributions.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractTestServerContribution contrib = abstractTestServerContributionArray[n2];
                    contrib.dispose();
                    ++n2;
                }
                contributions = null;
            }
        }
        this.tempDirectory = null;
        plugin = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractTestServerContribution[] getContributions() {
        if (plugin == null) {
            return new AbstractTestServerContribution[0];
        }
        Object object = syncObj;
        synchronized (object) {
            if (contributions == null) {
                IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TEST_SERVER_CONTRIBUTION_ID);
                ArrayList<AbstractTestServerContribution> contribs = new ArrayList<AbstractTestServerContribution>(elements.length);
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    try {
                        Object o = element.createExecutableExtension("class");
                        if (o instanceof AbstractTestServerContribution) {
                            contribs.add((AbstractTestServerContribution)o);
                        }
                    }
                    catch (CoreException e) {
                        TestServerPlugin.getDefault().log((Exception)((Object)e));
                    }
                    ++n2;
                }
                contributions = contribs.toArray(new AbstractTestServerContribution[contribs.size()]);
            }
            return contributions;
        }
    }

    public static TestServerPlugin getDefault() {
        return plugin;
    }

    public static final Shell getShell() {
        IWorkbenchWindow workbenchWindow;
        Shell shell = null;
        Display display = TestServerPlugin.getDisplay();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if (shell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void log(Exception e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public void log(String msg) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, msg));
    }

    public void log(String msg, Exception e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, (Throwable)e));
    }

    public void logWarning(String msg) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, msg));
    }

    public IPath getTempDirectory() {
        return this.tempDirectory;
    }
}

